; Mecha Taisen on Planet Oldskool PLUS
;
; a516 is next
;
; are the bugs gone!?
;
; I changed initcoords (untested)
;
; there was a bug causing 44256 not to counterattack?
;
; when filling up hp, etc. before intermission... reset some flags maybe?
;               that is, if I ever get the magic stuff implemented
;
; ii+d ... d is signed
;
; aichooseweapon needs to look for weapons above 50% see a182
;
; aren't beam weapons supposed to be ineffective in water?
;
; be careful about the size values in bc for copyonce and copy3times!
; if c is 0 then b is right, if c>0 then add 1 to b
;
; note that loadmap throws away some bits so only 16 maps are possible now
;
; change dec b, jr nz,axx to djnz
;
;
; RAM map
;
; $E000         unused ?
; $E001         zero if no music is playing
; $E002         controller input
; $E003         set to 1 when music loops
; $E004         if 1, sprite attributes table will be copied during VB
; $E005         controller input from last frame
; $E006         which buttons were just pressed
; $E007-9       misc used by copy3times and textwindow
; $E00A         current map
; $E00B         map width
; $E00C         map height
; $E00D-E       address of map in ROM
; $E00F-10      current map scroll position
; $E011         player's team #
; $E012-3       player's crosshair position
; $E014         delay before key repeat (starts at 0 and counts up)
; $E015         counter for repeat rate
; $E016-7       misc (used by placewindow)
; $E018-9       storage for pointer to unit data
; $E01A         misc used by stats window thing and attack UI
; $E01B         misc used by movement UI and attack UI
; $E01C-D       storage of current cursor/unit position
; $E01E         current crosshair sprite pattern
; $E01F         countdown for setting border red
; $E020-1       pointer storage used by attack UI
; $E022         selectathing2 customizations (1=call fillwstats 2=unitslists)
; $E023-4       storage for old crosshair position used by movement
; $E025         tells crosshairdoodad whether to update sprite after moving
; $E026-7       storage for pointer to opponent's unit data
; $E028-9       value for repositioning outgoing numerical stuff (attackinfwin)
; $E02A-B       pointer to the weapon you're going to use
; $E02C-D       misc used by AI (# of weps and distance)
; $E02E-33      for comparing weapon accuracy and suitablility
; $E034-5       base aim % for player vs enemy, enemy vs player
; $E036-7       pointer to the weapon enemy is going to use
; $E038-9       chances to hit
; $E03A-B       mystery rubbish (old copies of the R register)
; $E03C-D       pointer to the opponent's unit data when calling dealdamage
; $E03E         number of pilots on player's team
; $E03F         nonzero if unit was destroyed when dealdamage is called
; $E040-2       player's cash
; $E043         number of the weapon (0-5) that player is using
; $E044         number of the weapon (0-5) the enemy is using
; $E045         copied from $43 or $44 for use by consumeammo
; $E046-7       pointer to ammo table for player's unit (for fillwstats)
; $E048         bit 7 set if fillwstats finds a weapon is out of ammo/en
;                               or if it is not "P" when necessary                
; $E049         bit 2 set if attack routines are called AFTER MOVEMENT
; $E04A-C       backups of e01c and e01b when calling attack ui from movement
; $E04D         current area # (not necessarily the same as map #)
; $E04E         page of units in iunitslist (0,8,16,24)
; $E04F         set to 1 if statswin stuff was called as a sub routine
;               set to 2 if weapons list stuff called by weapons upgrade
;               set to 4 if weapons list stuff called for counterattack
; $E050-5F      stupid ugly list of which units are in the display window
; $E060         misc, used by iunitslist and AI engine
; $E061         tells dealdamage what terrain the target unit is on
; $E062         critical hit screen flash
; $E063         the team that the enemy AI is acting as
; $E064         set to 1 if there is a minimum range for weapons that player can choose
; $E065         some misc used in selectathing that used to be $E026
; $E066         bit 0 = defend mode, bit 1 = evade mode
; $E067         used by aichooseweapon
; $E068-6A      used by enemy movement routine
; $E06B         used to remember target unit number by AI engine
; $E06C         set to 2 if battleheader should swap sides
; $E06D         set to 4 if chancetohit shouldn't print the result
; $E06E-F       most recent cash earnings \
; $E070-1       most recent exp earnings   \ for popup window
; $E072         nonzero if placeunits was just done and shouldn't be done
;                again (my coding is getting lazy and sloppy!)
;
; $E080-C0      music player (see below)
;
; $E100-FF      stack
; $E200-7F      copy of sprite attributes table
; $E280-E67F    64 units... * 16 bytes each
;               2 bytes HP
;               2 bytes EN
;               2 bytes armor
;               1 byte unit type
;               1 byte attributes bit 3-4 = team        bit5=movED
;               1 byte pilot number                  0=nonexistant unit
;               1 byte pilot level
;               1 byte pilot attributes (seishin)
;               1 byte structure upgrades
;               1 byte weaponry upgrades/speed upgrades (high/low nibble)
;               1 byte h position
;               1 byte seishin points
;               1 byte v position
; $E680-E6BF   experience (two bytes, second byte=level) for each pilot
; $E6C0-E6DF   pilots that are on player's team
; $E6E0-E71F   list of units' pilots (for units that were destroyed)
;
; $E740-E8BF   ammo for each possible weapon on each possible unit
;
; $F000-F3FF?? map of units
;

mptr    equ $E080
countd  equ $E082
timer   equ $E083               ; unused
volume  equ $E085
attack  equ $E08A
decay1  equ $E08F
decay2  equ $E094
T1L     equ $E099
release equ $E09E
state   equ $E0A3
vibjunk equ $E0A8
avolume equ $E0AD
freqs   equ $E0B7

;
; I/O map
;
; $98 VDP VRAM data read/write      
; $99 VDP address setup, control register write, status register read
; $9A VDP
; $9B VDP
; $9C VDP
; $9D VDP
; $9E VDP
; $9F VDP
;               VDP register writes - data byte, $80 + register
;               VRAM write address setup - bits 0-7, $40 + bits 8-13
;               VRAM read address setup - bits 0-7, bits 8-13
;       status register - bits 0-4 number of 5th sprite
;                         bit 5 sprites overlapped
;                         bit 6 5th (or 9th) sprite
;                         bit 7 vb IRQ
;       register 0 - bit 0 external video input enable
;                    bits 1-3 mode M3-M5
;                    bit 4 - H-blank int enable (MSX2)
;                    bit 5 - light pen enable (9938 only)
;                    bit 6 - digitize mode (MSX2)
;       register 1 - bit 0 sprite zoom enable
;                    bit 1 - sprite size
;                    bit 3 - mode M2
;                    bit 4 - mode M1
;                    bit 5 - V-blank int enable
;                    bit 6 - screen enable
;                    bit 7 - VRAM size (0=4K 1=16K)
;       register 2 - address bits A10-A16 of map/bitmap
;       register 3 - address bits A6-A13 of color table
;       register 4 - address bits A11-A16 of charset
;       register 5 - address bits A7-A14 of sprite attribute table
;       register 6 - address bits A11-A16 of sprite charset
;       register 7 - bits 0-3 background/border color
;                    bits 4-7 foreground color in text mode
;                    in screen 8 its border color (8-bit RGB)
;                    in screen 6 its special-ed
;
;
; $A0 PSG address latch
; $A1 PSG data write
; $A2 PSG data read
;       00-1 channel A frequency (12 bits)
;       02-3 channel B freq             (f = 111862Hz / period)
;       04-5 channel C freq
;       06   noise freq (5 bits)
;       07   port&mixer config  bit 0-2 tone A, B, C enable (active low)
;                               bit 3-5 noise A, B, C enable (active low)
;                               bit 6   always set to 0
;                               bit 7   always set to 1
;       08   channel A volume   bit 0-3 = level
;       09   channel B volume   bit 4 - 0=fixed, 1=envelope generator
;       0A   channel C volume
;       0B-C envelope frequency (16 bits)  (f = 6991Hz / period)
;       0D   envelope control
;       0E   input port data    bit 0 - up
;                               bit 1 - down
;                               bit 2 - left
;                               bit 3 - right
;                               bit 4 - TRGA
;                               bit 5 - TRGB
;                               bit 6 - JIS/50
;                               bit 7 - CM1
;       0F   output port data
;                               bit 0 - TRGA1
;                               bit 1 - TRGB1
;                               bit 2 - TRGA2
;                               bit 3 - TRGB2
;                               bit 4 - STB1
;                               bit 5 - STB2
;                               bit 6 - port select for input bits 0-5
;                               bit 7 - /KANA
;
; $A8 slot config register (bits 0&1 control $0000-$3FFF)
; $A9 keyboard signal read
; $AA bits 0-3 kb drive, 4=REM, 5=cassette write, 6=/CAPS, 7=PPISND
; $AB mode control
;
; sprite attributes
; byte 0 = y-1
; byte 1 = x
; byte 2 = pattern (lowest two bits ignored for 16x16)
; byte 3 = color + bit 7 = early clock enable (shift left 32)
;

        org 0
        jp $C000

        org $38
        jp vbint

vbint
        exx
        ex af,af'

        in a,($99)
        bit 7,a
        jp z,notvdp

        push ix
        push iy

        ld a,($E01F)            ; red border countdown
        cp 0
        jr z,a116
        ld bc,$8799
        dec a
        ld ($E01F),a
        cp 0
        jr nz,a118
        out (c),a
        push af
        pop af
        out (c),b
        jr a116
a118
        ld a,8
        out (c),a
        push af
        pop af
        out (c),b
a116

        ld a,($E062)            ; critical hit screen flash
        cp 0
        jr z,a273
        sub 10
        ld ($E062),a
        ld bc,$8799
        and 4
        jr z,a274
        ld a,15
        out (c),a
        push af
        pop af
        out (c),b
        jr a273
a274
        out (c),a
        push af
        pop af
        out (c),b
a273

        ld a,($E004)
        cp 1                    ; optionally copy sprite attributes table
        jp nz,a23
        ld bc,$0099
        out (c),b
        ld b,$5C
        nop
        out (c),b
        ld hl,$E200
        ld bc,$8098
        otir
;        ld a,0
        xor a
        ld ($E004),a
a23

        ld a,($E03A)
        ld ($E03B),a
        ld a,r
        sla a
        ld ($E03A),a

        ld a,($E002)
        ld ($E005),a            ; controller status from last frame

        ld bc,$0FA0
        out (c),b
        ld a,131
        out ($A1),a
        dec b
        out (c),b
        in a,($A2)      
        ld ($E002),a            ; controller status 0UDLRAB

        ; keyboard scanner
        ld hl,$E002
        in a,($AA)
        and $F0
        or 8
        out ($AA),a
        in a,($A9)              
        bit 0,a
        jr nz,a480
        res 4,(hl)
a480
        bit 7,a
        jr nz,a481
        res 3,(hl)
a481
        bit 6,a
        jr nz,a482
        res 1,(hl)
a482
        bit 5,a
        jr nz,a483
        res 0,(hl)
a483
        bit 4,a
        jr nz,a484
        res 2,(hl)
a484
        in a,($AA)
        and $F0
        or 2
        out ($AA),a
        in a,($A9)              
        bit 7,a
        jr nz,a485
        res 5,(hl)
a485

        ld a,($E005)
        cpl
        ld b,a
        ld a,($E002)
        or b
        ld ($E006),a            ; which buttons were just pressed

abcdef
        ld a,($E001)
        cp 0
        jp z,a251

a250
        ; MUSIC PLAYER

        ld d,3          ; number of channels to process
        ld ix,volume
a315                         ; big loop for emulating envelope
        ld a,(ix+30)    ; status
        and a
        jp nz,a316
        ld a,(ix+25)    ; release
        call subvol     ; KEY OFF
        jp a317
a316
        cp 1            ; KEY ON
        jp nz,a320
        ld a,(ix+5)     ; attack
        srl a
        jp nc,a831
        ld b,a
        ld a,(ix+45)    ; avolume low byte
        adc a,127
        ld (ix+45),a    ; avolume low byte
        ld a,b
a831
        adc a,(ix+40)   ; avolume high byte
        ld (ix+40),a
        cp (ix+0)         ; volume
        jp c,a317
        ld a,(ix+0)       ; volume
        ld (ix+40),a    ; avolume high byte
        inc (ix+30)     ; status
        jp a317
a320
        cp 2            ; DECAY 1
        jp nz,a321
        ld a,(ix+10)    ; decay1        
        call subvol
        ld b,0
        ld a,(ix+20)    ; T1L
        ld hl,0
        and a
        jp z,a836
        ld c,(ix+20)    ; volume
a834
        add hl,bc
        dec a
        jp nz,a834
        srl h
        rr l
        srl h
        rr l
        srl l
        srl l
        srl l
a836
        ld a,l
        cp (ix+40)      ; avolume high byte
        jp c,a317
        inc (ix+30)     ; status
        jp a317
a321
        ld a,(ix+45)    ; avolume low byte
        sub (ix+15)     ; DECAY2
        ld (ix+45),a
        jp nc,a317
        dec (ix+40)     ; avolume high byte
a317
        ; check that volume hasn't underflowificated
        ld a,(ix+40)
        and a
        jp p,a319
;        ld a,0
        xor a
        ld (ix+40),a    ; avolume high byte
a319
        inc ix
        dec d
        jp nz,a315

a4

        ; store volumes
        ld bc,$08A0
        ld a,(avolume)
        srl a
        out (c),b
        out ($A1),a
        ld a,(avolume+1)
        srl a
        inc b
        out (c),b
        out ($A1),a
        ld a,(avolume+2)
        srl a
        inc b
        out (c),b
        out ($A1),a


; parse some song data (...or not)

        ld hl,(mptr)
        ld a,(countd)
        and a
        jp z,a307
        dec a
        ld (countd),a
        jp a314
a307
        ld a,(hl)
        inc hl
        ld c,a
        cp 255
        jp nz,a326
        ld c,(hl)
        inc hl
        ld b,(hl)
        push bc
        pop hl                ; jump
        ld a,1
        ld ($E003),a
        jp a307
a326
        and 224
        jp nz,a310
        ld b,0
        ld a,(hl)
        inc hl          
        ld ix,volume
        add ix,bc
        ld (ix+0),a               ; set a register
        jp a307
a310
        cp 32
        jp nz,a312
        ld a,31
        and c
        ld (countd),a           ; wait some frames
        jp a314
a312
        cp 128
        jp nz,a313
        ld a,28
        and c
        srl a
        srl a
        ld e,a
        ld d,0
        ld ix,freqs             ; set frequency
        add ix,de
        ld a,3
        and c
        ld (ix+0),a
        ld a,(hl)
        inc hl
        ld (ix+5),a
        jp a307
a313
        cp 64
        jp nz,a308
        ld a,14
        and c
        ld ix,state
        srl a
        ld e,a
        ld d,0
        add ix,de
        ld a,1
        and c
        ld (ix+0),a               ; key on/off
        jp a307
a308
        cp 96
        jp nz,a395
        ld a,7
        and c
        ld e,a
        ld d,0
        ld ix,vibjunk
        add ix,de
        ld a,16
        and c
        ld (ix+0),a               ; vibrato on/off
        jp a307
a395
        cp 160
        jp nz,a837
        inc hl                  ; panning (not needed)
a837
        jp a307
a314
        ld (mptr),hl


        ld ix,vibjunk
        ld iy,freqs
        ld d,3          ; number of channels (again)
a396
        ld a,(ix+0)
        and a
        jp z,a397
	inc a
        cp 26
        jp nz,a398
        ld a,16
a398
        ld (ix+0),a
        ld c,a
        ld a,(iy+0)
        and a
        jp nz,a399
        ld a,(iy+5)
        cp 140
        jp nc,a399
        ld a,10
        add a,c
        ld c,a
a399
        ld hl,vibpat-16
        ld b,0
        add hl,bc
        ld a,(hl)
        ld c,a
        cp 255
        jp z,a880
        ld c,0
a880
        add a,(iy+5)
        ld (iy+5),a
        ld a,(iy+0)
        adc a,c
        ld (iy+0),a
a397
        inc ix
        inc iy
        dec d
        jp nz,a396

        ld bc,$00A0
        out (c),b
        ld a,(freqs+5)
        out ($A1),a
        inc b
        out (c),b
        ld a,(freqs)
        out ($A1),a
        inc b
        out (c),b
        ld a,(freqs+6)
        out ($A1),a
        inc b
        out (c),b
        ld a,(freqs+1)
        out ($A1),a
        inc b
        out (c),b
        ld a,(freqs+7)
        out ($A1),a
        inc b
        out (c),b
        ld a,(freqs+2)
        out ($A1),a

a251

        pop iy
        pop ix
notvdp
        exx
        ex af,af'

nullint
        ei
        ret

subvol
        ld b,0
        sla a
        rl b
        sla a
        rl b
        ld c,a
        ld a,(ix+45)            ; avolume low byte
        sub c
        ld (ix+45),a
        ld a,(ix+40)            ; avolume high byte
        sbc a,b
        ld (ix+40),a
        ret

vibpat
        db 1,1,0,255,255,255,255,0,1,1
        db 0,1,0,0,255,0,255,0,0,1

greatj
        incbin "justice.dt"
        db 255
        dw greatj+5

mota3
        incbin "mota3.dt"
        db 255
        dw mota3+5

intromus
        incbin "o012.dt"
        db 255
        dw intromus+5

titleblk
        incbin "title2.blk"
titleclr
        incbin "title2.clr"
titlemap
        incbin "title2.map"
thefont
        incbin "font.blk"
iblocks
        incbin "iblocks"
icolors
        incbin "icolors"
area1map
        incbin "area1l.map"
area1walk
        incbin "area1l.w"
iceblk
        incbin "ice.blk"
iceclr
        incbin "ice.clr"
icemap
        incbin "ice.map"
icewalk
        incbin "ice.w"
forestblk
        incbin "area2.blk"
forestclr
        incbin "area2.clr"
forestmap
        incbin "area2.map"
forestwalk
        incbin "area2.w"
desertblk
        incbin "desert.blk"
desertclr
        incbin "desert.clr"
desertmap
        incbin "desert.map"
desertwalk
        incbin "desert.w"

walkaddrs
        dw area1walk
        dw forestwalk
        dw icewalk
        dw desertwalk
        dw area1walk

initcoords
        db 0,0,0,0,0,0,0,0          ; unused
        db 10,10,10,0,1,1,1,0
        db 10,10,10,0,1,1,1,0
        db 10,10,10,0,9,9,9,0 
        db 1,15,3,0,1,4,14,0 

mapaddrs
        dw forestblk
        dw forestclr
        dw area1map
        db 20,16
        dw area1aunits0
        dw nounits
        dw nounits
        dw area1aunits3

        dw forestblk
        dw forestclr
        dw forestmap
        db 16,12
        dw area2aunits0
        dw nounits
        dw area2aunits2
        dw nounits

        dw iceblk
        dw iceclr
        dw icemap
        db 16,12
        dw area3aunits0
        dw area3aunits1
        dw nounits
        dw nounits

        dw desertblk
        dw desertclr
        dw desertmap
        db 16,12
        dw area4aunits0
        dw nounits
        dw nounits
        dw area4aunits3

        dw forestblk
        dw forestclr
        dw area1map
        db 20,16
        dw area5aunits0
        dw area5aunits1
        dw area5aunits2
        dw area5aunits3


mapaddrs2
        dw forestblk
        dw forestclr
        dw area1map
        db 20,16
        dw nounits
        dw area1bunits1
        dw nounits
        dw area1bunits3

        dw forestblk
        dw forestclr
        dw forestmap
        db 16,12
        dw nounits          
        dw area2bunits1
        dw area2bunits2
        dw nounits

        dw iceblk
        dw iceclr
        dw icemap
        db 16,12
        dw area3bunits0
        dw area3bunits1
        dw nounits
        dw nounits

        dw desertblk
        dw desertclr
        dw desertmap
        db 16,12
        dw nounits    
        dw area4bunits1
        dw nounits
        dw area4bunits3

        dw forestblk
        dw forestclr
        dw area1map
        db 20,16
        dw area5bunits0
        dw area5bunits1
        dw area5bunits2
        dw area5bunits3


mapaddrs3
        dw forestblk
        dw forestclr
        dw area1map
        db 20,16
        dw nounits
        dw nounits
        dw area1cunits2
        dw area1cunits3

        dw forestblk
        dw forestclr
        dw forestmap
        db 16,12
        dw area2cunits0
        dw nounits
        dw area2cunits2
        dw nounits

        dw iceblk
        dw iceclr
        dw icemap
        db 16,12
        dw nounits
        dw area3cunits1
        dw area3cunits2
        dw nounits

        dw desertblk
        dw desertclr
        dw desertmap
        db 16,12
        dw nounits
        dw nounits
        dw area4cunits2
        dw area4cunits3

        dw forestblk
        dw forestclr
        dw area1map
        db 20,16
        dw area5cunits0
        dw area5cunits1
        dw area5cunits2
        dw area5cunits3

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

        org $4000
        db $41,$42
        dw startup
startup

        di

;        ld a,0
        xor a
        ld hl,$E000
        ld (hl),a               ; clear some RAM
        ld de,$E001             ;
        ld bc,$03FF
        ldir

        ld hl,$E1FF
        ld sp,hl

        in a,($A8)              
        rrca
        rrca
        and 3                   ; which slot are we?
        ld c,a
        ld b,0                  
        ld hl,$FCC1             
        add hl,bc               
        cp (hl)               ; is it a subslot?
        jp m,a6
        in a,($A8)            ; nope, that makes it easy
        and $CC
        or c
        sla c
        sla c
        sla c
        sla c
        or c
        out ($A8),a
        jr a7
a6
        inc hl                  ; is a subslot so more work to do
        inc hl
        inc hl
        inc hl
        ld a,(hl)
        and $CC
        ld b,a
        and $0C
        ld c,a
        srl c
        srl c
        sla a
        sla a
        or b
        or c
        ld e,a

        in a,($A8)
        and $CC
        ld b,a
        and $0C
        ld c,a
        srl c
        srl c
        sla a
        sla a
        or b
        or c
        ld d,a

        sla a
        sla a
        out ($A8),a
        ld a,e
        ld ($FFFF),a            ;
        ld a,d                  ; phew!
        out ($A8),a             ;

a7        
        ; setup VDP stuff
        ld bc,$8099
        ld hl,vdpregs
a8
        ld a,(hl)
        inc hl
        out ($99),a
        push af
        pop af
        out (c),b

        inc b
        ld a,$88
        cp b
        jr nz,a8

        in a,($99)
        ei

a21

        ; copy title screen
        ld hl,titleblk
        ld de,$4000
        ld bc,$0800
        call copy3times
        ld hl,titleclr
        ld de,$6000
        ld bc,$0800
        call copy3times

        ld hl,titlemap
        ld de,$5800
        ld bc,$0300
        call copyonce

        halt

        ; start music
        ld hl,greatj+5
        ld (mptr),hl    ; address of music
        ld a,1
        ld ($E001),a

;        ld a,0
        xor a
        ld ($E003),a

a11
        halt

        ld a,($E003)            ; title screen music over?
        cp 1
        jp nz,a15
;        ld a,0
        xor a
        ld ($E001),a            ; turn music off again
        call clearvram
        call soundoff
        ld b,66
a28
        halt              ; waste time
        dec b
        jr nz,a28
        call introstory
        jp a21                  ; restart
a15

        ld a,($E002)
        and 16
        cp 16
        jr nz,a17

        jp a11

a17
;        ld a,0
        xor a
        ld ($E001),a            ; turn music off again
        call soundoff

        call clearvram
        ld hl,thefont
        ld de,$4400
        ld bc,$0400
        call copy3times
        call setbw

        ld hl,spritepats
        ld de,$7800
        ld bc,$0800
        call copyonce

        call cleargamedata

a115


        ld hl,teammenu
        ld de,$5A27
        call textwindow
        halt
        ld de,$3892
        ld c,3
        call selectathing       ; returns with the answer in b
        ld a,255
        cp b
        jr z,a115

a463
        ld a,b
        ld ($E011),a

firstmap

;        ld a,0
        xor a
        ld ($E03E),a

; clear experience table
        ld hl,$E680
        ld b,64
a214
        ld (hl),0
        inc hl
        djnz a214

;        ld a,0
        xor a
nextmap
        call loadmap
        call loadmapunits

        ; TESTING
;        ld a,4
;        call loadmap
;        call loadmapunits


        call clearobits

        call fillallammo

; put unit gfx in vram (each team has its own icon for units)

        ld hl,iblocks
        ld de,$4300
        ld bc,$0180             ;
        call copy3times
        ld hl,icolors
        ld de,$6300
        ld bc,$0180             ; really only $80 bytes!
        call copy3times
        call scrollmap

        ld bc,$0608
        ld ($E012),bc           ; crosshair position

        call updateunitmap

        ; start music
        halt
        ld hl,mota3+5
        ld (mptr),hl    ; address of music
        ld a,1
        ld ($E001),a

        ld a,4
        ld ($E01E),a
        ld ix,$E012
        call a45                  ; place crosshair
        halt

        jr a93

a18
        call crosshairdoodad
        ld a,($E072)
        cp 0
        jr z,a502
        xor a
        ld ($E072),a
        jr a503
a502
        call placeunits
a503
        halt
a93

        ; button press for terrain info or unit stats
        ld a,($E006)
        bit 5,a
        jp nz,a188
        call searchunitmap
        cp 0
        jp nz,a230
        call searchterrain
        ld hl,mapmenu3
        cp 2
        jr z,a165
        ld b,a
        ld a,($E00A)
        cp 3
        jr nz,a164
        ld hl,mapmenu5
        ld a,1
        cp b
        jr z,a165
        ld hl,mapmenu4
        jr a165
a164
        ld hl,mapmenu2
        ld a,1
        cp b
        jr z,a165
        ld hl,mapmenu1
a165
        call placewindow
        call textwindow
        call waitbutton
        jp a69
a230
        dec a
        ld b,0
        sla a
        sla a
        sla a
        rl b
        sla a
        rl b
        ld c,a
        ld ix,$E280
        add ix,bc
        ld ($E018),ix
        jp a65
a188

        ; button press for menu??
        ld a,($E006)
        bit 4,a
        jp nz,a55
a87
        call searchunitmap
        cp 0
        jp nz,a62
        ld hl,endturnwin
        call placewindow
        call textwindow
        halt
        ld de,($E016)
        ld hl,$1008
        add hl,de
        push hl
        pop de
        ld c,2
        call selectathing       ; returns with the answer in b
        ld a,255
        cp b
        jp z,a69
        ld a,1
        cp b
        jp z,a69

        ; um... now execute the AI for the enemy phase and other minor
        ; details like that...

        call scrollmap
        call updateunitmap
        call placeunits

        xor a
        ld ($E063),a
a306
        ld a,($E011)
        ld b,a
        ld a,($E063)
        cp b
        jp z,a309
        ld b,64
        sla a
        sla a
        sla a
        ld c,a
        ld ix,$E280
a311
        ld a,(ix+7)
        and 24
        cp c
        jp nz,a400
        ld a,(ix+8)
        cp 0
        jp z,a400
        push bc

        ld c,(ix+13)
        ld b,(ix+15)
        ld ($E01C),bc
        ld a,4
        ld ($E01E),a
        push ix
        ld ix,$E01C
        call a45                  ; place crosshair
        halt
        pop ix
        ld b,15
a432
        halt
        djnz a432               ; delay

        ; find the nearest hostile unit
        ld a,127
        ld ($E060),a
        ld iy,$E280
        ld b,64
        ld a,($E063)
        sla a
        sla a
        sla a
        ld c,a
a401
        ld a,(iy+7)
        and 24
        cp c
        jp z,a402
        ld a,(iy+8)
        cp 0
        jp z,a402
        push bc
        ld bc,($E01C)
        ld e,(iy+13)
        ld d,(iy+15)
        ld a,c
        cp e
        jr nc,a403
        ld a,e
        sub c
        jr a404
a403
        sub e
a404
        ld c,a
        ld a,b
        cp d
        jr nc,a405
        ld a,d
        sub b
        jr a406
a405
        sub d
a406
        add a,c         ; distance
        pop bc
        ld d,a
        ld a,($E060)
        cp d
        jr c,a402
        ld a,d
        ld ($E060),a
        ld a,64
        sub b
        ld ($E06B),a
        ld e,(iy+13)
        ld d,(iy+15)
        ld ($E026),iy
        ld ($E012),de
a402
        ld de,$0010
        add iy,de
        djnz a401

        ; can we attack from this distance?

        ; change this stuff to use aichooseweapon
        ; (check dependencies)
        xor a
        ld ($E067),a
        ld a,($E060)            ; distance to the closest enemy
        ld ($E02D),a
        call aichooseweapon2
        ld a,($E044)
        cp 255
        jp z,a409               ; can't attack, need to move
;        ld ($E02A),hl

splargh
;        call unitpointer2
;        ld a,(iy+11)            ; number of weapons
;        ld ($E02C),a
;        ld de,$0014
;        add iy,de
;        dec a
;        ld ($E044),a
;        cp 0
;        jr z,a407
;        ld de,$0018
;a408
;        add iy,de
;        dec a
;        jr nz,a408
;a407
;        ld a,($E060)            ; distance to the closest enemy
;        cp (iy+20)
;        jr z,a410
;        jp nc,a409
a410
        ; ATTACK
        ld ($E02A),hl
;        ld ($E02A),iy
        ld ($E018),ix
        ld a,12
        ld ($E01E),a
        push ix
        ld ix,$E012
        call a45                  ; place crosshair
        halt

        xor a
        ld ($E066),a

        ld b,77
a413
        halt
        djnz a413               ; delay
        call clearspr
        ld a,1
        ld ($E004),a
        halt

        ld ix,($E026)
        ld a,(ix+7)
        srl a
        srl a
        srl a
        and 3
        ld hl,$E011
        cp (hl)
        jp z,a412
        ; target does not belong to player, so...
        call aichooseweapon
        ld ($E036),hl
        call calcaims
        ld a,4
        ld ($E06D),a
        ld a,($E034)            ; chance to hit
        ld iy,($E02A)
        call chancetohit
        ld ($E038),a        
;        ld a,4
;        ld ($E06D),a
;        ld a,($E035)            ; chance to hit
;        ld iy,($E036)
;        call chancetohit
;        ld ($E039),a
        jp a421
a412
        ; bring up info and menu for player
        xor a
        ld ($E049),a

        call calcaims
a418
        ld hl,attackinfwin+2
        ld de,$58E2
        ld bc,$061A
        call textwindow2
        ld hl,targettedwin
        ld de,$5A04
        call textwindow

        ld ix,($E018)
        ld hl,($E02A)
        ld bc,0
        ld ($E028),bc
        call fillhalfinf

        ld de,$59B6
        call setvrama3
        ld a,($E034)            ; chance to hit
        ld iy,($E02A)
        call chancetohit
        ld ($E038),a        

a414
        ld de,$208C
        ld c,3
        call selectathing
        ld a,255
        cp b
        jr z,a414
        xor a
        cp b
        jr nz,a415
        ; bring up weapons list
        ld a,4
        ld ($E04F),a

        ld ix,($E018)           ;
        ld iy,($E026)           ; fudge some pointers
        ld ($E018),iy           ;
        push ix
        ld hl,weaponswin
        ld de,$5901
        call textwindow
        ld a,1
        ld ($E064),a
        call a419
        pop ix
        ld ($E018),ix

        ld a,255
        cp b
        jp z,a418
        ld hl,($E020)
        ld a,b
        ld ($E043),a
        sla a
        sla a
        sla a
        ld c,a
        sla a
        add a,c
        ld c,a
        ld b,0
        add hl,bc
        ld ($E036),hl                
        jr a421
a415
        ld a,1
        cp b
        jr nz,a416
        ; defend
        ld a,1
        ld ($E066),a
        jr a422
a416
        ; evade
        ld a,2
        ld ($E066),a
a422
        ld bc,noweapon
        ld ($E036),bc

a421
        ld a,4
        ld ($E06D),a
;        ld de,$59B6
 ;       call setvrama
        ld a,($E035)            ; chance to hit
        ld iy,($E036)
        call chancetohit
        ld ($E039),a

        ; TIME FOR L-GAIM (computer initiates attack)
        ld hl,0
        ld ($E070),hl
        call clearscr

        ld hl,battlewin
        ld de,$5801
        call textwindow
        ld hl,battlewin
        ld de,$5810
        call textwindow

        ld a,2
        ld ($E06C),a
        call battleheader

        ld de,$5915
        ld iy,($E026)
        call putmechagfx2

        ld de,$5903
        ld iy,($E018)
        call flipmechagfx2

        ld a,($E066)
        bit 1,a                 ; evade mode?
        jr z,a434
        ld a,($E038)
        srl a
        jr a435
a434
        ld a,($E038)
a435
        call truefalse
        ld de,$5A37
        push af
        call batman
        ld ix,($E018)
        ld iy,($E02A)
        ld a,($E044)
        ld ($E045),a
        call consumeammo
        pop af
        cp 0
        jp z,a424

        ld de,($E01C)
        call searchterrain2             ; player's terrain
        ld ($E061),a
        ld bc,24
        ld ($E028),bc
        ld bc,($E026)
        ld ($E03C),bc
        ld a,2
        ld ($E06C),a
        call dealdamage

        ld a,($E03F)
        cp 0
        jp z,a424
        xor a        
        call explosion
; check if it is GAME OVER or not
        ld ix,$E280
        ld b,64
a452
        ld a,(ix+8)
        cp 0
        jr z,a453
        ld a,(ix+7)
        srl a
        srl a
        srl a
        and 3
        ld hl,$E011
        cp (hl)
        jp z,a425                 ; no game over, but no more counter attack
a453
        ld de,$0010
        add ix,de
        djnz a452
; game over
        ld b,75
a456
        halt
        djnz a456
        call clearscr
        ld a,($E00A)
        call loadmap
        call scrollmap
        call updateunitmap
        call placeunits

        ld hl,gameoverwin
        ld de,$594B
        call textwindow
        ld b,250
a451
        halt
        djnz a451
        xor a
        ld ($E001),a            ; turn music off again
        call clearvram
        call soundoff
        jp a21                  ; restart
a424

        ld iy,($E036)
        bit 7,(iy+23)           ; anna tooku kara kougeki dekiru no ka?
        jp nz,a425
        ld a,($E039)
        call truefalse
        ld de,$5A21
        push af
        call batman
        ld ix,($E026)
        ld iy,($E036)
        ld a,($E043)
        ld ($E045),a
        call consumeammo
        pop af
        cp 0
        jp z,a425

        call searchterrain      ; enemy's terrain
        ld ($E061),a
        ld bc,0
        ld ($E028),bc
        ld bc,($E018)
        ld ($E03C),bc
        ld a,2
        ld ($E06C),a
        call dealdamage

        ld a,($E03F)
        cp 0
        jr z,a486
;        xor a
        call explosion

        ld ix,($E018)
        ld iy,($E026)
        ld a,(iy+7)
        srl a
        srl a
        srl a
        and 3
        ld hl,$E011
        cp (hl)
        jp nz,a486
        call earnexp2

        ; earn some meseta
        call unitpointer
        ld l,(iy+18)
        ld h,(iy+19)
        ld ($E06E),hl
        ld bc,($E040)
        add hl,bc
        ld ($E040),hl
        ld a,($E042)
        adc a,0
        ld ($E042),a
a486

        call countenemies
        xor a
        cp c
        jp nz,a425
        pop ix
        pop bc
        ld hl,areaclearwin
        ld de,$5A2B
        jp endlevel
a425

        ld b,75
a423
        halt
        djnz a423

        call clearscr
        ld a,($E00A)
        call loadmap
        call scrollmap
        call updateunitmap
        call placeunits
        call earnedpopup
        ld a,4
        ld ($E01E),a

        pop ix
        jp a411
a409
        ; enemy is out of range so move closer
        call unitpointer2
        ld a,(ix+12)
        and 15
        srl a
        add a,(iy+9)             ; movement ability
        ld ($E06A),a        
        ld iy,($E026)
        ld e,(iy+13)
        ld d,(iy+15)
        ld ($E068),de

        ; decide on an unoccupied destination
        ld c,1
a450
        ld hl,0
a457
        ld l,0
a458
        ld a,l
        add a,h
        ld d,a
        ld a,c
        sub d
        jr c,a455

        ld de,($E068)
        ex de,hl
        add hl,de
        ex de,hl
        call movementrubbish
        cp 0                    ; possible or not?
        jp z,a449
        ld de,($E068)
        ex de,hl
        scf
        ccf
        sbc hl,de
        ex de,hl
        call movementrubbish
        cp 0                    ; possible or not?
        jp z,a449
        ld de,($E068)
        ld a,d
        add a,h
        ld d,a
        ld a,e
        sub l
        ld e,a
        call movementrubbish
        cp 0                    ; possible or not?
        jp z,a449
        ld de,($E068)
        ld a,d
        sub h
        ld d,a
        ld a,e
        add a,l
        ld e,a
        call movementrubbish
        cp 0                    ; possible or not?
        jp z,a449

a455
        inc l
        ld a,c
        cp l
        jr nz,a458
        inc h
        ld a,c
        cp h
        jr nz,a457
        inc c
        jp a450
a449
        ld a,($E06A)
        ld b,a
a437
        ld a,(ix+13)
        cp e
        jr z,a438
        jr nc,a439
        inc (ix+13)
        jr a440
a439
        dec (ix+13)
        jr a440
a438
        ld a,(ix+15)
        cp d
        jr z,a441
        jr nc,a442
        inc (ix+15)
        jr a440
a442
        dec (ix+15)
a440
        jr z,a441
        djnz a437
a441

        ld c,(ix+13)
        ld b,(ix+15)
        ld ($E01C),bc
        
        push ix
        call scrollmap
        call updateunitmap
        call placeunits
        ld a,4
        ld ($E01E),a
        ld ix,$E01C
        call a45                  ; place crosshair
        halt
        pop ix
        ld b,35
a443
        halt
        djnz a443               ; delay

        ; can it attack with a P weapon?
        call aichoosep
;        push hl
;        pop iy
;        bit 7,(iy+23)           ; anna tooku kara kougeki dekiru no ka?
;        jr nz,a411
        ld a,($E044)
        cp 255
        jp z,a411               ; anna tooku kara kougeki dekiru no ka?
        

; figure out new distance between units and store in e060
        call calcrange
        ld ($E060),a

        jp a410
a411
        pop bc        
a400
        ld de,$0010
        add ix,de
        dec b
        jp nz,a311
a309
        ld a,($E063)
        inc a
        ld ($E063),a
        cp 4
        jp nz,a306

        ; player's units back to the state of not having moved
        ld ix,$E280
        ld d,64
        ld bc,16
a189
        res 5,(ix+7)
        add ix,bc
        dec d
        jr nz,a189
        jp a69

a62
        ; actions menu for player's unit
        dec a
        ld b,0
        sla a
        sla a
        sla a
        rl b
        sla a
        rl b
        ld c,a
        ld ix,$E280
        add ix,bc
        ld ($E018),ix
        ld a,(ix+7)             ; unit attributes (inc. team #)
        srl a
        srl a
        srl a
        and 7
        ld hl,$E011
        cp (hl)
        jp nz,a65
        ld hl,unitmenu
        call placewindow
        call textwindow
        halt
        ld de,($E016)
        ld c,4
        call selectathing       ; returns with the answer in b
        ld a,255
        cp b
        jp z,a69

;        ld a,0
        xor a
        cp b
        jp nz,a82

        ; MOVEMENT
        call unitpointer
        ld a,(ix+12)
        and 15
        srl a
        add a,(iy+9)             ; movement ability
        ld ($E01B),a

        call scrollmap
        call updateunitmap
        call placeunits

        ld bc,($E012)
        ld ($E01C),bc
a83
        ld a,8
        ld ($E01E),a
        call rangedcrosshair

        ld a,($E006)
        bit 4,a
        jp nz,a84
        ; can they move here?
        call searchunitmap
        cp 0
        jp nz,a117              ; dame da, how about the border color flashing

;        Michelle
        ld ix,($E018)
        ld de,($E012)
        ld (ix+13),e
        ld (ix+15),d
        call scrollmap
        call updateunitmap
        call placeunits

; confirm new coordinates please...
        ld hl,movedmenu
        call placewindow
        call textwindow
        halt
        ld de,($E016)
        ld c,3
        call selectathing       ; returns with the answer in b
        ld a,255
        cp b
        jr z,a91
        ld a,2
        cp b
        jr z,a91
        ld a,1
        cp b
        jr z,a231

        ; ATTACK after movement
        ld a,4
        ld ($E049),a
        ld bc,($E01C)
        ld ($E04A),bc
        ld a,($E01B)
        ld ($E04C),a
        jp a145

        ; DONE
a231
        ld ix,($E018)
        set 5,(ix+7)
        ld a,4
        ld ($E01E),a
        call scrollmap
        call updateunitmap
        call placeunits
        jp a197

a232
        ; cancelled the ATTACK
        ld bc,($E04A)
        ld ($E01C),bc
        ld a,($E04C)
        ld ($E01B),a
a91
        ; changed their mind...
        ; put the unit back where it was
        ld ix,($E018)
        ld bc,($E01C)
        ld (ix+13),c
        ld (ix+15),b
        call scrollmap
        call updateunitmap
        call placeunits
        jp a83        
a84
        bit 5,a
        jp nz,a83
        ; canceled
        ld a,4
        ld ($E01E),a
        call clearspr
        ld a,1
        ld ($E004),a
        ld bc,($E01C)
        ld ($E012),bc
        halt
        jp a87          ; back to menu

a117
        ld a,40
        ld ($E01F),a
        jp a83

a82

        ld a,3
        cp b
        jp z,a69                ; cancel
a66
        ; STATS WINDOW
        ld a,2
        cp b
        jp nz,a70
a65
        call clearspr
        ld a,1
        ld ($E004),a
        halt

        ld hl,statswin
        ld de,$5902
        call textwindow
        ld de,$5928
        call setvrama
        call unitpointer
        ld bc,$0898
        call a71                ; unit name

        ld de,$5946     
        call setvrama
        call writehps

        ld de,$5966
        call setvrama
        call writeens

        ld de,$598A
        call setvrama
        ld l,(iy+8)             ; upgraded agility
        ld a,(ix+12)
        and 15
        cp 0
        jr z,a111
        ld de,10
a112
        add hl,de
        dec a
        jr nz,a112
a111
        ld e,0
        ld h,e
        call bintodec3           

        ld de,$59A9
        call setvrama
        ld l,(ix+4)             ; armor
        ld h,(ix+5)
        ld de,0
        call bintodec4

;        halt

        ld de,$59E9
        call setvrama
        call pilotpointer
        push iy
        pop hl
        ld bc,$0898
        call a71                ; pilot name

        ld de,$5A09
        call setvrama
        ld a,(ix+9)             ; level
        ld ($E01A),a
        ld l,a
        ld de,0
        ld h,d
        call bintodec3

        ld de,$5A16
        call setvrama2
        ld l,(ix+14)            ; SP
        ld de,0
        ld h,d
        call bintodec3

        ld de,$5A29
        call setvrama
        ld a,($E01A)
        add a,(iy+11)            ; aim
        ld l,a
        ld de,0
        ld h,d
        call bintodec3

        ld de,$5A36
        call setvrama2
        ld a,($E01A)
        add a,(iy+10)            ; evasion
        ld l,a
        ld de,0
        ld h,d
        call bintodec3

        ld de,$5A49
        call setvrama
        ld a,($E01A)
        add a,(iy+13)            ; skill
        ld l,a
        ld de,0
        ld h,d
        call bintodec3

        ld de,$5A56
        call setvrama2
        ld a,($E01A)
        add a,(iy+12)            ; reflex
        ld l,a
        ld de,0
        ld h,d
        call bintodec3

        ld de,$5A89
        call setvrama
        ld a,($E01A)
        add a,(iy+8)            ; close
        ld l,a
        ld de,0
        ld h,d
        call bintodec3

        ld de,$5A96
        call setvrama2
        ld a,($E01A)
        add a,(iy+9)            ; distant
        ld l,a
        ld de,0
        ld h,d
        call bintodec3

        ld a,($E04F)
        cp 0
        jr nz,a465              ; else mechagfx will overwrite starfield!

        ld de,$5932
        call putmechagfx
a465
        call waitbutton

        ld a,($E04F)
        cp 0
        jr z,a267
        xor a
        ld ($E04F),a
        ret
a267
        ld ($E04F),a

        jp a69
a70
        ld a,1
        cp b
        jp nz,a119
        xor a
        ld ($E049),a

        ; ATTACK
a145
        ld hl,weaponswin
        ld de,$5901
        call textwindow
a297
        xor a
        ld ($E064),a
a419
        call unitpointer

; bring up weapon list
        ld a,(iy+11)            ; number of weapons
        ld ($E01B),a
        ld ($E01A),a

        ld de,$5943
        ld bc,$0014
        add iy,bc
        ld ($E020),iy
        ld hl,($E020)
        ld ix,$E01A
a121
        call setvrama
        ld bc,$1098
        call a71
        ld a,$20
        add a,e
        ld e,a
        ld bc,$0005
        add hl,bc
        ld a,(hl)
        inc hl
        inc hl
        inc hl
        ld bc,$8098
        bit 2,a
        jr z,a130
        ld b,$B8
a130
        out (c),b
        bit 1,a
        jr z,a131
        ld b,$B7
        out (c),b
a131
        dec (ix+0)
        jr nz,a121

; weapon stats
        halt
        ld de,$5955
        ld a,($E01B)
        ld ($E01A),a
        ld iy,($E020)
a129
        call setvrama
        push de
        push ix
        ld ix,($E018)
        ld a,(ix+12)
        srl a
        srl a
        srl a
        srl a
        pop ix
        ld l,(iy+22)
        ld h,(iy+23)
        cp 0
        jr z,a300
        ld de,100
a301
        add hl,de               ; add on the upgrades
        dec a
        jr nz,a301
a300
        call bintodec
        ld a,$80
        out ($98),a
        ld l,(iy+16)
        ld h,0
        ld de,0
        call bintodecs
        pop de
        ld a,$20
        add a,e
        ld e,a
        ld bc,$0018
        add iy,bc
        dec (ix+0)
        jr nz,a129

        ld a,($E04F)
        cp 2
        jr nz,a296
        xor a
        ld ($E04F),a
        ret
a296

        ld a,($E04F)
        cp 4
        jr nz,a428
        ld a,($E06B)
        jr a429
a428

        call searchunitmap
        dec a
a429
        sla a
        ld c,a
        sla a
        add a,c
        ld c,a
        ld b,0
        ld hl,$E740
        add hl,bc
        ld ($E046),hl           ; address to ammo table for player's unit

        halt
        ld de,$1050
        ld a,($E01B)
        ld c,a
        ld a,8
        ld ($E203),a
        ld a,1
        ld ($E022),a
        ld a,16
        call selectathing2       ; returns with the answer in b

        ld a,($E04F)
        cp 4
        jr nz,a417
        xor a
        ld ($E04F),a
        ret
a417

        ld a,255
        cp b
        jr nz,a233
        ld a,($E049)
        bit 2,a                 ; is this an attack after movement?
        jp z,a87                ; no, back to main unit menu thing
        jp a232                 ; yes, back to movement UI

a233
        ; get range
        ld iy,($E020)
        ld a,b
        ld ($E043),a
        sla a
        sla a
        sla a
        ld c,a
        sla a
        add a,c
        ld c,a
        ld b,0
        add iy,bc
        ld a,(iy+20)
        ld ($E01B),a
        ld ($E02A),iy

        call scrollmap
        call updateunitmap
        call placeunits

        ld bc,($E012)
        ld ($E01C),bc
a122
        ld a,12
        ld ($E01E),a
        call rangedcrosshair

        ld a,($E006)
        bit 4,a
        jp nz,a123
        call searchunitmap
        cp 0            ; very important!
        jp z,a128
; check whether the selected unit is on your own team
        dec a           ; also very important!
        sla a
        sla a
        ld b,0
        sla a
        rl b
        sla a
        rl b
        ld c,a
        ld ix,$E280
        add ix,bc
        ld ($E026),ix
        ld a,(ix+7)
        srl a
        srl a
        srl a
        and 3                   ; there was retarded bug here (7 instead of 3)
        ld d,a
        ld a,($E011)
        cp d
        jp z,a128

        ; attack info window
        call clearspr
        ld a,1
        ld ($E004),a
        halt

        ld hl,attackinfwin
        ld de,$58E2
        call textwindow

        xor a
        ld ($E066),a            ; enemys don't get defend/evade modes

        call calcaims

        ld ix,($E018)
        ld hl,($E02A)
        ld bc,0
        ld ($E028),bc
        call fillhalfinf

        ld de,$59B6
        call setvrama3
        ld a,($E034)            ; chance to hit
        ld iy,($E02A)
        call chancetohit
        ld ($E038),a        

        ld ix,($E026)
        call aichooseweapon
        ld ($E036),hl
        ld bc,$00E0
        ld ($E028),bc
        call fillhalfinf
; utsukushii
        ld de,$59B6
        call setvrama3
        ld a,($E035)            ; chance to hit
        ld iy,($E036)
        call chancetohit
        ld ($E039),a

        call waitbutton
        bit 5,a
        jr nz,a190
        call scrollmap
        call placeunits
        jp a122
a190
        ; TIME FOR L-GAIM (player initiates attack)
        ld hl,0
        ld ($E070),hl
        call clearscr

        ld hl,battlewin
        ld de,$5801
        call textwindow
        ld hl,battlewin
        ld de,$5810
        call textwindow

        call battleheader

        ld de,$5915
        call putmechagfx

        ld de,$5903
        call flipmechagfx

        ld a,($E038)
        call truefalse
        ld de,$5A21
        push af
        call batman
        ld ix,($E018)
        set 5,(ix+7)            ; unit has MOVED 
        ld iy,($E02A)
        ld a,($E043)
        ld ($E045),a
        call consumeammo
        pop af
        cp 0
        jp z,a212

        call searchterrain      ; enemy's terrain
        ld ($E061),a
        ld bc,0
        ld ($E028),bc
        ld bc,($E026)
        ld ($E03C),bc
        call dealdamage

        call earnexp

        ld a,($E03F)
        cp 0
        jr z,a212
;        xor a
        call explosion
        ; earn some meseta
        ld ix,($E026)
        call unitpointer2
        ld l,(iy+18)
        ld h,(iy+19)
        ld ($E06E),hl
        ld bc,($E040)
        add hl,bc
        ld ($E040),hl
        ld a,($E042)
        adc a,0
        ld ($E042),a

        call countenemies
        xor a
        cp c
        jp nz,a213
        call waitbutton
        call clearscr
        ld a,($E00A)
        call loadmap
        call scrollmap
        call placeunits
        ld a,4
        ld ($E01E),a
        call clearspr
        ld a,1
        ld ($E004),a
        halt
        ld hl,areaclearwin
        ld de,$594B
endlevel
        call textwindow
        ld b,200
a237
        halt
        djnz a237
        call repairunits
        call clearscr
        jp intaamishon2

;        jp a213                 ; no more counter attack to worry about
a212

        ld iy,($E036)
        bit 7,(iy+23)           ; anna tooku kara kougeki dekiru no ka?
        jr nz,a213
        ld a,($E039)
        call truefalse
        ld de,$5A37
        push af
        call batman
        ld ix,($E026)
        ld iy,($E036)
        ld a,($E044)
        ld ($E045),a
        call consumeammo
        pop af
        cp 0
        jr z,a213

        ld de,($E01C)
        call searchterrain2             ; player's terrain
        ld ($E061),a
        ld bc,24
        ld ($E028),bc
        ld bc,($E018)
        ld ($E03C),bc
        call dealdamage

        ld a,($E03F)
        cp 0
        jr z,a507
        xor a
        call explosion
a507

a213

        call waitbutton

        call clearscr
        ld a,($E00A)
        call loadmap

        call scrollmap
        call updateunitmap
        call placeunits
        call earnedpopup

        ld bc,($E01C)
        ld ($E012),bc
        ld a,4
        ld ($E01E),a
        jp a197         ; all done with battle scene, back to strategizing

a123
        bit 5,a
        jp nz,a122
        ; canceled
        ld a,4
        ld ($E01E),a
        call clearspr
        ld a,1
        ld ($E004),a
        ld bc,($E01C)
        ld ($E012),bc
        halt
        jp a145         ; back to menu

a128
        ld a,40
        ld ($E01F),a
        jp a122

a119
        ; magic not yet implemented

a132
        call waitbutton
a69
        call scrollmap
        call updateunitmap
a197
        ld ix,$E012
        call a45                  ; place crosshair
        halt

a55

;        call kanaled

        jp a18

earnedpopup
        ld hl,($E070)
        xor a
        cp h
        jr nz,a488
        cp l
        jr z,a487
a488
        ld hl,earnedwin
        ld de,$5A28
        call textwindow
        ld de,$5A50
        call setvrama
        ld de,0
        ld hl,($E070)
        call bintodec3           
        ld de,$5A6D
        call setvrama
        ld de,0
        ld hl,($E06E)
        call bintodec
        call waitbutton
        call scrollmap
        call updateunitmap
        call placeunits
a487
        ld de,0
        ld ($E06E),de
        ret

movementrubbish
        bit 7,h
        jr nz,a461
        bit 7,l
        jr nz,a461
        push bc
        push hl
        push de
        call searchunitmap2
        pop de
        cp 0
        jr nz,a454
        ld bc,($E01C)
        call calcrange2
        ld b,a
        ld a,($E06A)
        cp b
        jr c,a454
        xor a
a454
        pop hl
        pop bc
        ret
a461
        ld a,64
        ret

hp2max
        ld ix,$E280
        ld b,64
a286
        ld a,(ix+8)
        cp 0
        jr z,a287
        push bc
        call unitpointer2

        ld l,(iy+12)
        ld h,(iy+13)
        ld a,(ix+11)            ; calculate upgraded max HP
        cp 0
        jr z,a290
        ld de,200
a291
        add hl,de
        dec a
        jr nz,a291
a290
        ld (ix+0),l
        ld (ix+1),h

        ld l,(iy+14)
        ld h,(iy+15)
        ld a,(ix+11)            ; calculate upgraded max EN
        cp 0
        jr z,a288
        ld de,10
a289
        add hl,de
        dec a
        jr nz,a289
a288
        ld (ix+2),l
        ld (ix+3),h

        ld l,(iy+16)
        ld h,(iy+17)
        ld a,(ix+11)            ; calculate upgraded armor
        cp 0
        jr z,a292
        ld de,100
a293
        add hl,de
        dec a
        jr nz,a293
a292
        ld (ix+4),l
        ld (ix+5),h

        ld a,(ix+9)
        add a,60
        ld (ix+14),a

        pop bc
a287
        ld de,$0010
        add ix,de
        djnz a286
        ret

explosion
        ; a is 0 if explosion goes on the right
        ; sprites start at $14

        ld de,$5903
;        ld de,$5915

        ld iy,$E240
        cp 0
        jr nz,a512
        ld e,$15
        ld a,184
        jr a513
a512
        ld a,40
a513
        push de
        ld d,a
        ld e,$48
        ld b,12
a508
        ld a,($E03B)
        and 31
        add a,e
        ld (iy+0),a
        ld a,r
;        srl a
;        srl a
;        srl a
        and 31
        add a,d
        ld (iy+1),a
        ld a,$10
        ld (iy+2),a
        ld a,8
        ld (iy+3),a
        inc iy
        inc iy
        inc iy
        inc iy
        call animatecarnage
        djnz a508

        call animatecarnage
        call animatecarnage
        call animatecarnage

        pop de
        call erasemecha

        ret

animatecarnage
        ld ix,$E240
        ld c,12
a509
        ld a,(ix+2)
        add a,4
        cp $20
        jr nz,a511
        ld a,228
        ld (ix+0),a
;        jr a510
a511
        ld (ix+2),a
a510
        inc ix
        inc ix
        inc ix
        inc ix
        dec c
        jr nz,a509
        ld a,1
        ld ($E004),a
        halt
        halt
        halt
        halt
        halt
        ret
        
theend
;        ld a,0
        xor a
        ld ($E001),a            ; turn music off again
        halt
        call soundoff
        halt

        call displayweird

a472
        jp a472

intaamishon2
        ld a,($E04D)
        inc a
        cp 5
        jp z,theend
        ld ($E04D),a
        ld a,($E00A)
        inc a
        ld ($E00A),a

;        ld bc,40000
;        ld ($E040),bc           ; debugging!

        call fillallammo

;        ld a,0
        xor a
        ld ($E001),a            ; turn music off again
        halt
        call soundoff
        halt

        ; start music
        ld hl,intermus+5
        ld (mptr),hl    ; address of music
        ld a,1
        ld ($E001),a

intaamishon
        call displaystarf

        call hp2max

        ld de,0
        ld ($E06E),de           ; clear last cash value

        ld hl,interwin1
        ld de,$5829
        call textwindow
        ld hl,interwin2
        ld de,$5A84
        call textwindow
        ld hl,interwin3
        ld de,$58C4
        call textwindow

        ld de,$5AAF
        call setvrama
        ld a,($E04D)
        add a,$9B
        out ($98),a

        call displaycash

a285
        ld de,$1F33
        ld c,5
        call selectathing       ; returns with the answer in b

        ld a,255
        cp b
        jr z,a285
        xor a
        cp b
        jr nz,a249
a268
;         " see stats      "
        ld hl,interwin6
        ld de,$582C
        call textwindow
        call iunitslist         ; returns with answer in b
        ld a,255
        cp b
        jp z,intaamishon
        ld a,1
        ld ($E04F),a
        call a65
        jr a268
a249
        ld a,1
        cp b
        jr nz,a275
a276
;         " assign pilot   "
        ld hl,interwin4
        ld de,$5829
        call textwindow
        call iunitslist         ; returns with answer in b
        ld a,255
        cp b
        jp z,intaamishon
        ld ix,($E018)
        push ix

        ld hl,interwin5
        ld de,$5829
        call textwindow
        call iunitslist         ; returns with answer in b
        ld a,255
        cp b
        jp z,a276

        ld ix,($E018)
        ld a,(ix+8)             ; pilot in the destination unit
        pop iy
        ld b,(iy+8)
        ld (ix+8),b
        ld (iy+8),a
        jp intaamishon
a275
        ld a,2
        cp b
        jr nz,a277
;        db " upgrade units  "
        ld hl,interwin7
        ld de,$5829
        call textwindow
a278
        call iunitslist
        ld a,255
        cp b
        jp z,intaamishon
        ld hl,upgradewin
        ld de,$58E6
        call textwindow
        ld de,$303A
        ld c,2
        call selectathing
        ld a,255
        cp b
        jr z,a278
        ld ix,($E018)
;        ld a,0
        xor a
        cp b
        jr nz,a279
        ; structure upgrade
        ld a,(ix+11)
        call upgradecost
        ld (ix+11),a
        call displaycash
        jp a278
a279
        ; mobility upgrade
        ld a,(ix+12)
        and 15
        call upgradecost
        ld b,a
        ld a,(ix+12)
        and 240
        or b
        ld (ix+12),a
        call displaycash
        jp a278
a277
        ld a,3
        cp b
        jr nz,a295
;         " upgrade weapons"
        ld hl,interwin8
        ld de,$5828
        call textwindow
a298
        call iunitslist         ; returns with answer in b
        ld a,255
        cp b
        jp z,intaamishon
a299
        ld hl,weaponswin+2
        ld de,$5901
        ld bc,$071C
        call textwindow2
        ld a,2
        ld ($E04F),a
        call a297
        call waitbutton
        bit 5,a
        jr z,a298
        ld ix,($E018)
        ld a,(ix+12)
        srl a
        srl a
        srl a
        srl a
        call upgradecost
        sla a
        sla a
        sla a
        sla a
        ld b,a
        ld a,(ix+12)
        and 15
        or b
        ld (ix+12),a
        call displaycash
        jp a299
a295
;         " goto next area "
        ld hl,$E011
        ld a,($E00A)
        sla a
        sla a
        sla a
        add a,(hl)
        ld ix,initcoords
        ld c,a
        ld b,0
        add ix,bc
        ld e,(ix+0)
        ld d,(ix+4)
        ld ix,$E280
        ld b,64
a460
        ld a,(ix+7)
        srl a
        srl a
        srl a
        and 3
        cp (hl)
        jr nz,a462
        res 5,(ix+7)
        ld (ix+13),e
        ld (ix+15),d
a462
        push de
        ld de,$0010
        add ix,de
        pop de
        djnz a460

        call clearscr
        halt

        ld a,($E00A)
        jp nextmap

a238
        jp a238

displaycash
        ld de,$5AB7
        call setvrama
        ld a,($E042)
        ld hl,($E040)
        cp 0
        jr z,a239
        ld bc,$86A0     ; 100000-65536
        cp 1
        jr nz,a240
        sbc hl,bc
        jr c,a241
        ld a,$9C
        out ($98),a
        jr a239
a241
        ld hl,($E040)
        ld bc,60000
        ccf
        sbc hl,bc
        ld de,$0601
a243
        call bintodecb
;        jr a242
        ret
a240
        ; assume a is 2 and total is less than 195,535
        ; due to extreme laziness
        ld a,$9C
        out ($98),a
        ld bc,1072
        add hl,bc
        ld de,$0301
        jr a243
a239
        call bintodec
a242
        ret

upgradecost
        ld hl,3000
        push af
        cp 0
        jr z,a280
        push hl
        pop bc
a281
        add hl,bc
        dec a
        jr nz,a281
a280
        push hl
        halt
        ld hl,upgradeconfirm
        ld de,$58E9
        call textwindow
        ld de,$5912
        call setvrama
        pop hl
        push hl
        call bintodec
        ld de,$4842
        ld c,2
        call selectathing
        pop hl
        xor a
        cp b
        jr z,a284
        pop af
        ret
a284
        ld a,($E042)
        cp 0
        jr nz,a282
        ld a,($E041)
        cp h
        jr c,nocash
        jr nz,a282
        ld a,($E040)
        cp l
        jr c,nocash
a282
        ld de,($E040)
        ex de,hl
        scf
        ccf
        sbc hl,de
        ld ($E040),hl
        jr nc,a283
        ld a,($E042)
        dec a
        ld ($E042),a
a283
        pop af
        inc a
        ret
nocash
        ld hl,notenoughwin
        ld de,$58E8
        call textwindow
        call waitbutton
        pop af
        ret

iunitslist
        xor a
        ld ($E04E),a

a255
        ld ix,$E270

        ld hl,emptywin
        ld de,$58C4
        ld bc,$0812
        call textwindow2

        ld de,$58CC
        call setvrama           ;
        ld a,($E04E)            ; place x/x page number indicator
        srl a                   ;
        srl a
        srl a
        add a,$9C
        out ($98),a
        push af
        pop af
        ld a,$A5
        out ($98),a
        push af
        pop af
        ld a,$9F
        out ($98),a

        ld de,$58E6
        ld hl,$E011
        ld b,0
        ld iy,$E050
a252
        call setvrama
a253
        push bc
        ld bc,$0010
        add ix,bc
        pop bc
        ld a,$E6
        cp ixh
        jr nz,a257
        ld a,$80
        cp ixl
        jr z,a258
a257
        ld a,(ix+8)
        cp 0
        jr z,a253
;        cp 10
;        jr nc,a253
        ld a,(ix+7)             ; unit attributes (inc. team #)
        srl a
        srl a
        srl a
        and 3
        cp (hl)
        jp nz,a253

        ld a,($E04E)
        cp b
        jr z,a269
        jr c,a269
        inc b
        jr a253
a269
        ; print names
        push bc
        push hl
        push iy
        call unitpointer2
        ld bc,$0898
        call a71                ; unit name
        ld hl,$0020
        add hl,de
        ex de,hl

        ld bc,$8098
        out (c),b
        call pilotpointer
        push iy
        pop hl
        ld bc,$0898
        call a71                ; pilot name
        pop iy

        push ix
        pop hl
        ld (iy+0),l
        ld (iy+1),h
        inc iy
        inc iy

        pop hl
        pop bc

        inc b
        ld a,($E04E)
        ld c,a
        ld a,b
        sub c
        cp 8
        jr nz,a252
a258
        ld a,b
        ld ($E060),a
a294
        ld de,$1F33
        ld c,8
        ld a,7
        ld ($E203),a
        ld a,2
        ld ($E022),a
        call selectathing2       ; returns with the answer in b

        bit 6,b
        jr z,a260               
        bit 7,b
        jr z,a265
        ld b,255
        ret
a265
        ld hl,$E04E             ; change pages for unitlist
        bit 3,a
        jr nz,a261
        ld a,8
        add a,(hl)
        jr a262
a261
        ld a,(hl)
        sub 8
a262
        bit 7,a                 ; check that page is in the range 0-3
        jr z,a263
        xor a
        jr a264
a263
        cp 32
        jr nz,a264
        ld a,24
a264
        ld (hl),a
        jp a255
a260
        ; a unit was selected (or maybe just an empty space...)
        ld a,($E04E)
        add a,b
        ld c,a
        ld a,($E060)
        dec a
        sub c
        jp c,a294

        ld a,b
        sla a
        add a,$50
        ld l,a
        ld h,$E0
        ld a,(hl)
        ld ($E018),a
        inc hl
        ld a,(hl)
        ld ($E019),a
        ret
        
countenemies
        ld ix,$E280
        ld bc,$4000
        ld hl,$E011
        ld de,$0010
a235
        ld a,(ix+8)
        cp 0
        jr z,a236
        ld a,(ix+7)             ; unit attributes (inc. team #)
        srl a
        srl a
        srl a
        and 3
        cp (hl)
        jp z,a236
        inc c
a236
        add ix,de
        djnz a235
        ret

consumeammo
;                      acc,critical,en,ammo,range,flags
        ld a,(iy+18)
        cp 0
        jr z,a224
        ld c,a
        ld b,0
        ld l,(ix+2)
        ld h,(ix+3)
        sbc hl,bc
        ld (ix+2),l
        ld (ix+3),h
        ret
a224
        ld a,(iy+19)
        cp 0
        jr z,a225
        push ix
        pop hl
        ld bc,$E280
        sbc hl,bc
        srl h
        rr l
        srl h
        rr l
        ld a,l
        srl l
        add a,l
        ld c,a
;        ld a,0
        xor a
        adc a,0
        ld b,a
        ld a,($E045)
        add a,$40
        ld l,a
        ld h,$E7
        add hl,bc
        dec (hl)
a225
        ret

earnexp
        ld iy,($E018)
        ld ix,($E026)
earnexp2
        ld c,(iy+8)
        ld hl,$E6C0
        ld a,($E03E)
        ld b,a
        ld d,0
a215
        ld a,(hl)
        cp c
        jr z,a216
        inc d
        inc d
        inc hl
        djnz a215       ; if we search the list and dont find it we're FUBAR
a216
        ld c,d
        ld b,0
        ld l,$80
        add hl,bc
        ld c,10
        ld a,($E03F)
        cp 0
        jr z,a217
        ld c,100
        ld a,(ix+8)             ; who is the enemy pilot?
        cp 5
        jr z,a217
        ld c,150
a217
        ld a,(ix+9)             ; what level are they?
        ld d,(iy+9)             ; what level are we?
        cp d
        jr z,a218
        jr c,a219
a220
        sla c
        rl b
;        dec a
;        cp d
;        jr nz,a220
        jr a218
a219
        srl c
;        dec d
;        cp d
;        jr nz,a219
a218
        ld e,(hl)
        inc hl
        ld d,(hl)
        ex de,hl
        add hl,bc
        ld ($E070),bc
        ex de,hl
        ld (hl),d
        dec hl
        ld (hl),e
        ld (iy+9),d
        ret

dealdamage
        ld a,(ix+12)            ; weapon upgrades
        ld l,(iy+22)
        ld h,(iy+23)
        srl a
        srl a
        srl a
        srl a
        jr z,a207
        ld bc,100
a206
        add hl,bc
        dec a
        jr nz,a206
a207
        ld a,(iy+17)            ; critical hit rate
        add a,(ix+9)            ; + pilot level
        ld b,a
        ld c,(iy+21)            ; flags
        push bc
        ld a,(iy+20)            ; range
        push af
        push hl
        call pilotpointer
        pop hl
        ; close, ranged, evasion, aim, reflex, skill, seishin x 2
        pop af
        cp 1
        jr nz,a208
        ld a,(iy+8)             ; close attack power
        add a,(ix+9)            ; pilot level
        jr a209
a208
        ld a,(iy+9)             ; distant attack power
        add a,(ix+9)            ; pilot level
a209
        add a,28
        ld b,a
        xor a
        push hl
        pop de
a210
        add hl,de
        adc a,0
        djnz a210
        sla h
        rl a
        ld l,h
        ld h,a
        ld ix,($E03C)
        ld e,(ix+4)             ; opponent's armor
        ld d,(ix+5)
        sbc hl,de

        bit 7,h
        jr nz,a222
        xor a
        cp h
        jr nz,a223
        ld a,10
        cp l
        jr c,a223
a222                    
        ld hl,10                ; minimum damage is 10
a223

        pop bc

        ; critical hits
        ld a,b
        add a,(iy+13)           ; pilot skill
        ld d,a
        push bc
        push hl
        call pilotpointer
        ld a,(iy+13)           ; opponent pilot skill
        add a,(ix+9)            ; + pilot level
        ld e,a
        ld a,d
        sub e
        jr nc,a270
        xor a
a270
        cp 101
        jr c,a271
        ld a,100
a271
        call truefalse
        pop hl
        cp 100
        jr nz,a272
        ld ($E062),a            ; critical hit!!
        push hl
        pop bc
        srl b
        rr c
        add hl,bc
a272
        pop bc

        ; still need to mess with beams, sword blocking?

        ; terrain defense bonus
        ld a,($E061)
        cp 1
        jr z,a305
        cp 2
        jr nz,a304
a305
        push hl
        pop de
        srl d
        rr e
        srl d
        rr e
        srl d
        rr e
        sbc hl,de
a304

        ld a,($E066)
        bit 0,a                 ; defend mode?
        jr z,a436
        srl h
        rr l
a436

        ld de,$58E1
        call setvrama3
        push hl
        call bintodec
        pop hl

        ld e,(ix+0)             ; opponent's HP
        ld d,(ix+1)
        ex de,hl
        sbc hl,de
        ld (ix+0),l
        ld (ix+1),h
        xor a
        ld ($E03F),a
        bit 7,h
        jr z,a211
        ; unit is BLOWED UP!
        ld a,(ix+7)             ; unit attributes (inc. team #)
        srl a
        srl a
        srl a
        and 3
        ld hl,$E011
        cp (hl)
        jr nz,a245
        ld bc,$E280
        push ix
        pop hl
        scf
        ccf
        sbc hl,bc
        srl h
        rr l
        srl h
        rr l
        srl l
        srl l
        ld a,63
        and l
        ld c,a
        ld b,0
        ld hl,$E6E0
        add hl,bc
        ld a,(ix+8)
        ld (hl),a
a245
        ld a,1
        ld ($E03F),a
        ld (ix+8),0
        ld (ix+0),0
        ld (ix+1),0
a211

;        call battleheader
;        ret

battleheader
        ld ix,($E018)
        ld a,($E06C)
        cp 2
        jr nz,a426
        ld ix,($E026)
a426
        call unitpointer2
        ld de,$5833
        call setvrama
        call writehps
        ld de,$5853
        call setvrama
        call writeens

        ld ix,($E026)
        ld a,($E06C)
        cp 2
        jr nz,a427
        ld ix,($E018)
a427
        call unitpointer2
        ld de,$5824
        call setvrama
        call writehps
        ld de,$5844
        call setvrama
        call writeens
        xor a
        ld ($E06C),a
        ret

repairunits
        ld ix,$E280
        ld hl,$E6E0
        ld b,64
a244
        ld a,(hl)
        cp 0
        jr z,a246
        ld (ix+8),a
        push bc
        push hl
        call unitpointer2
        ld c,(iy+18)
        ld b,(iy+19)
        ld hl,($E040)
        scf
        ccf
        sbc hl,bc
        ld a,($E042)
        sbc a,0
        ld ($E042),a
        ld ($E040),hl
        pop hl
        pop bc
a246
        inc hl
        ld de,$0010
        add ix,de
        djnz a244

        ld a,($E042)
        bit 7,a
        jr z,a247
        xor a
        ld ($E042),a
        ld ($E041),a
        ld ($E040),a
a247
        ret

clearscr
        ld de,$5800
        call setvrama
        ld a,$80
        ld bc,$0300
a191
        out ($98),a
        push af
        pop af
        dec c
        jr nz,a191
        dec b
        jr nz,a191
        ret

batman
        cp 0
        jr z,a203
        ld hl,hitwin
        jr a204
a203
        ld hl,misswin
a204
        call textwindow
        ld b,100
a205
        halt
        djnz a205
        ret

truefalse
        cp 0
        jr z,a198
        cp 100
        jr z,a198
        ld b,a
        ld hl,0
        ld de,655
a199
        add hl,de
        dec b
        jr nz,a199
        ld a,($E03A)
        cp h
        jr c,a200
        jr z,a201
a202
        xor a
        jr a198
a201
        ld a,($E03B)
        cp l
        jr nc,a202
a200
        ld a,100
a198
        halt
        ret

chancetohit
        bit 7,a
        jr nz,a186
        ld l,a
        ld a,(iy+16)
;        cp 128
 ;
        bit 7,a
        jr nz,a184
        add a,l
a187
        cp 101
        jr c,a185
a186
        ld a,100
        jr a185
a184
        add a,l
        bit 7,a
        jr z,a187
        xor a
a185
        push af
        ld l,a
        ld a,($E06D)
        cp 4
        jr nz,a430
        xor a
        ld ($E06D),a
        jr a431
a430
        ld h,0
        ld de,0
        call bintodec3
a431
        pop af
        ret

calcaims
        call unitpointer
        call a179
        push hl
        add hl,bc
        ld bc,100
        add hl,bc
        ld ($E02E),hl           ; player aim
        pop hl
        ld c,a
        add hl,bc
        ld ($E030),hl           ; player evasion

        ld ix,($E026)
        call unitpointer2
        call a179
        push hl
        add hl,bc
        ld bc,100
        add hl,bc
        ld ($E032),hl           ; enemy aim
        pop hl
        ld c,a
        add hl,bc               ; enemy evasion

        ld a,($E02E)
        sub l
        ld d,a
        ld a,($E02F)
        sbc a,h
        bit 7,a
        jr z,a180
        ld d,0
a180
        ld a,d
        ld ($E034),a            ; player vs enemy

        ld hl,($E032)
        ld bc,($E030)
        scf
        ccf
        sbc hl,bc
        bit 7,h
        jr z,a181
        ld l,0
a181
        ld a,l
        ld ($E035),a            ; enemy vs player

        call searchterrain      ; enemy's terrain
        cp 1
        jr nz,a302
        ld a,($E034)
        ld b,a
        srl b
        srl b
        srl b
        sub b
        ld ($E034),a
a302

        ld de,($E01C)           ; player's terrain
        call searchterrain2
        cp 1
        jr nz,a303
        ld a,($E035)
        ld b,a
        srl b
        srl b
        srl b
        sub b
        ld ($E035),a
a303

        ret

a179
        ld h,0
        ld l,(iy+8)             ; upgraded agility
        ld a,(ix+12)
        and 15
        cp 0
        jr z,a177
        ld de,10
a178
        add hl,de
        dec a
        jr nz,a178
a177
        call pilotpointer
        ld a,(ix+9)             ; level
        add a,(iy+12)            ; reflex
        ld c,a
        ld b,0
        add hl,bc

        ld a,(ix+9)             ; level
        add a,(iy+11)            ; aim
        ld c,a

        ld a,(ix+9)             ; level
        add a,(iy+10)            ; evasion

        ret


pilotpointer
        ld a,(ix+8)             ; pilot number
        ld iy,pilotdata
        ld b,0
        sla a
        rl b
        sla a
        rl b
        sla a
        rl b
        sla a
        rl b
        ld c,a
        add iy,bc
        ret

aichoosep
        ; only pick P weapons
        ld a,1
        ld ($E067),a
        jr a444

aichooseweapon
        xor a
        ld ($E067),a
a444
        call calcrange
        ld ($E02D),a

aichooseweapon2
        call unitpointer2
        ld a,(iy+11)            ; number of weapons
        ld ($E02C),a
        ld d,a
        ld hl,$E02E
;                      acc,critical,en,ammo,range,flags
; weapon flags bit0=blockable bit1=beam bit2="P" bit3=MAP
a174       
;        ld a,(iy+41)
;        bit 3,a
        bit 3,(iy+41)           ; is it a MAP weapon?
        jp nz,a173
        ld a,($E067)            ; does it have to be P?
        cp 0
        jr z,a445
        bit 2,(iy+41)
        jp z,a173
a445
        ld a,(iy+38)            ; does it need EN?
        cp 0
        jr z,a446
        ld c,a
        ld a,(ix+3)
        cp 0
        jr nz,a447
        ld a,(ix+2)
        cp c
        jp c,a173
        jr a447
a446
        ld a,(iy+39)            ; does it consume ammo?
        cp 0
        jr z,a447
        push ix
        pop bc          ; do ugly multistep process to check ammo
        srl b
        rr c
        srl b
        rr c
        ld a,c
        srl c
        ld b,0
        add a,c
        jr nc,a448
        inc b
a448
        ld c,a
        push hl
        ld a,l
        add a,$12
        ld h,$E7
        add hl,bc
        ld a,(hl)
        pop hl
        cp 0
        jr z,a173
a447
        ld c,(iy+40)
        ld a,($E02D)            ; is it within range?
        cp c
        jr z,a172
        jr c,a172
a173
        ; muda da tte itta darou!
        ld a,255
        ld (hl),a
a176
        ld bc,24
        add iy,bc
        inc hl
        dec d
        jr nz,a174
        jr a175
a172
        ; weapon OK, figure out chance to hit
        ld a,($E035)
        add a,(iy+36)
        ld (hl),a
        jr a176
a175
        ; pick strongest USEABLE weapon with greater than 50%
        dec hl
        ld a,(hl)
        cp 255
        jr z,a183
;        cp 50
;        jr c,a182
        ld a,l
        sub $2E
        ld ($E044),a            ; save weapon # for later
        sla a
        sla a
        sla a
        ld c,a
        sla a
        add a,c
        add a,20
        ld b,0
        ld c,a
        push bc
        call unitpointer2
        pop bc
        add iy,bc
        push iy
        pop hl                  ; address of weapon
        ret
a183
        ld a,$2E
        cp l
        jr nz,a175
        ld a,255
        ld ($E044),a            ; save weapon # for later
        ld hl,noweapon
        ret
a182
        ; see if accuracy for other weapons is better

        ; unimplemented

;        ret

calcrange
        ld bc,($E01C)
        ld de,($E012)
calcrange2        
        ld a,c
        cp e
        jr nc,a168
        ld a,e
        sub c
        jr a169
a168
        sub e
a169
        ld c,a
        ld a,b
        cp d
        jr nc,a170
        ld a,d
        sub b
        jr a171
a170
        sub d
a171
        add a,c         ; distance
        ret

introstory
        ld hl,thefont
        ld de,$4400
        ld bc,$0400
        call copy3times
        call setbw
        call displaystarf

        ; start music
        halt
        ld hl,intromus+5
        ld (mptr),hl    ; address of music
        ld a,1
        ld ($E001),a

;        ld a,0
        xor a
        ld ($E003),a

        ld b,50
        call a158

        ld hl,introwin1
        ld de,$5822
        call textwindow
        call a159

        ld hl,introwin2
        ld de,$5842
        call textwindow
        call a159
        ld b,90
        call a158

        ld hl,introwin3
        ld de,$5862
        call textwindow

a161
        halt
        ld a,($E006)
        bit 4,a
        jp z,a160
        ld a,($E003)            ; title screen music over?
        cp 1
        jp nz,a161
;        ld a,0
        xor a
        ld ($E001),a            ; turn music off again
        call clearvram
        call soundoff
        ld b,50
        call a158

        ret

a159
        ld b,0
a158
        halt
        ld a,($E006)
        bit 4,a
        jp z,a160
        halt
        ld a,($E006)
        bit 4,a
        jp z,a160
        dec b
        jr nz,a158
a160
        ret

fillhalfinf

        ; weapon name
        ld de,$598B
        call setvrama3
        ld bc,$1098
        call a71

        ld de,$590B
        call setvrama3
        call pilotpointer
        push iy
        pop hl
        ld bc,$0898
        call a71                ; pilot name

        ld de,$5918
        call setvrama3
        ld a,(ix+9)             ; level
        ld ($E01A),a
        ld l,a
        ld de,0
        ld h,d
        call bintodec3

        ld de,$592B
        call setvrama3
        call unitpointer2
        ld bc,$0898
        call a71                ; unit name

        ld de,$594F     
        call setvrama3
        call writehps

        ld de,$596F
        call setvrama3
        call writeens

        ret

writeens
        ld l,(ix+2)
        ld h,(ix+3)
        call bintodec           ;
        ld a,$A5                ; write unit EN
        out ($98),a             ;
        ld l,(iy+14)
        ld h,(iy+15)
        ld a,(ix+11)            ; calculate upgraded max EN
        cp 0
        jr z,a155
        ld de,10
a156
        add hl,de
        dec a
        jr nz,a156
a155
        call bintodec
        ret

writehps
        ld l,(ix+0)
        ld h,(ix+1)
        call bintodec           ;
        ld a,$A5                ; write unit HP
        out ($98),a             ;
        ld l,(iy+12)
        ld h,(iy+13)
        ld a,(ix+11)
        cp 0
        jr z,a153
        ld de,200               ; calculate upgraded max HP
a154
        add hl,de
        dec a
        jr nz,a154
a153
        call bintodec
        ret

rangedcrosshair
;        halt
        ld bc,($E012)
        ld ($E023),bc
        ld a,1
        ld ($E025),a
        call crosshairdoodad
        ld bc,($E01C)
        ld de,($E012)
        ld a,c
        cp e
        jr nc,a92
        ld a,e
        sub c
        jr a88
a92
        sub e
a88
        ld c,a
        ld a,b
        cp d
        jr nc,a89
        ld a,d
        sub b
        jr a90
a89
        sub d
a90
        add a,c         ; distance
        ld b,a
        ld a,($E01B)
        cp b
        jp nc,a151
        ; out of range, go back inside where you belong
        ld bc,($E023)
        ld ($E012),bc
a151
        ld ix,$E012
        call a45                  ; place crosshair
        halt
        ret

crosshairdoodad

        ld ix,$E012
        ld a,($E002)
        ld b,a
        and 15
        cp 15
        jr nz,a49
;        ld a,0
        xor a
        ld (ix+2),a
        ret
a49
        ld a,25
        cp (ix+2)
        jr nz,a47
        ld a,4
        cp (ix+3)
        jr z,a50
        inc (ix+3)
        ret
a50
        xor a
        ld (ix+3),a
        ld a,b
        jr a48
a47
        inc (ix+2)
        ld a,($E006)

a48
        bit 0,a
        jr nz,a42
        dec (ix+1)
a42
        bit 1,a
        jr nz,a43
        inc (ix+1)
a43
        bit 2,a
        jr nz,a44
        dec (ix+0)
a44
        bit 3,a
        jr nz,a147
        inc (ix+0)
a147

; bounds checking

        ld bc,($E00B)

        ld a,(ix+0)
        cp 255
        jr nz,a146
        inc (ix+0)
a146
        ld a,(ix+1)
        cp 255
        jr nz,a148
        inc (ix+1)
a148
        ld a,c
        cp (ix+0)
        jr nz,a149
        dec (ix+0)
a149
        ld a,b
        cp (ix+1)
        jr nz,a150
        dec (ix+1)
a150

        ld a,($E025)            ; relocate the actual sprite or not?
        cp 0
        jp nz,a46

a45

; scroll map to appropriate location

        ld de,($E00F)           ; note the current position
        push de 

        ld bc,($E00B)

        ld a,16
        cp c
        jr nz,a490
a494
        xor a
        ld ($E00F),a
        jr a491
a490
        ld a,(ix+0)
        sub 8
        jr c,a494
        ld ($E00F),a
        add a,16
        cp c
        jr z,a491
        jr c,a491
        ld a,c
        sub 16
        ld ($E00F),a

a491
        ld a,12
        cp b
        jr nz,a492
a495
        xor a
        ld ($E010),a
        jr a493
a492
        ld a,(ix+1)
        sub 6
        jr c,a495
        ld ($E010),a
        add a,12
        cp b
        jr z,a493
        jr c,a493
        ld a,b
        sub 12
        ld ($E010),a
a493

        ld bc,($E00F)           ; is new position the same as old?
        pop de
        ld a,c
        cp e
        jr nz,a500
        ld a,b
        cp d
        jr z,a501
a500
        push ix
        push iy
        call scrollmap
        call placeunits
        pop iy
        pop ix
        ld a,1
        ld ($E072),a
a501

        ld a,($E01E)
        ld ($E206),a            ;
        ld a,15                 ;
        ld ($E207),a            ; crosshair sprite

        ld a,(ix+0)
        ld bc,($E00F)
        sub c
        sla a
        sla a
        sla a
        sla a
        ld ($E205),a
        ld a,(ix+1)
        sub b
        sla a
        sla a
        sla a
        sla a
        dec a
        ld ($E204),a

        ld a,1
        ld ($E004),a
a46
        xor a
        ld ($E025),a
        ret

fillallammo
        ld ix,$E280
        ld hl,$E740
        ld e,64
a140        
        ld a,(ix+8)
        cp 0
        jr z,a141

        push hl
        call unitpointer2
        pop hl
        ld bc,$0018
        ld d,6
a142        
        ld a,(iy+39)
        ld (hl),a
        inc hl
        add iy,bc
        dec d
        jr nz,a142
        jr a226
a141
        ld bc,$0006
        add hl,bc
a226
        ld bc,$0010
        add ix,bc
a143
        dec e
        jr nz,a140
        ret

unitpointer
        ld ix,($E018)
unitpointer2
        ld a,(ix+6)
        ld iy,mechpointers
        sla a
        ld c,a
        ld b,0
        add iy,bc
        ld l,(iy+0)
        ld h,(iy+1)
        push hl
        pop iy
        ret

flipmechagfx
        ld iy,($E026)
flipmechagfx2
        push de

        ld c,(iy+6)
        sla c
        ld a,c
        sla c
        add a,c
        ld b,0
        ld c,a
        ld ix,mechagfx
        add ix,bc

        ld l,(ix+0)
        ld h,(ix+1)
        ld de,$4800
        ld bc,$0200
        call copyflipped

        ld l,(ix+2)
        ld h,(ix+3)
        ld de,$6800
        ld bc,$0200
        call copyonce

        ld l,(ix+4)
        ld h,(ix+5)
        push hl
        pop iy
        pop hl

        ld b,7  ;debugging
a195        
        ld c,$99
        di
        out (c),l
        push af
        pop af
        out (c),h
        ei

        ld c,8  ;debugging
a194
        dec iy
        ld a,(iy+8)
        cp 192
        jr c,a196
        sub 192
a196
        out ($98),a
        dec c
        jr nz,a194
        ld de,$0010
        add iy,de
        ld e,$20
        add hl,de
        dec b
        jr nz,a195

        ret

putmechagfx
        ld iy,($E018)
putmechagfx2
        push de

        ld c,(iy+6)
        sla c
        ld a,c
        sla c
        add a,c
        ld b,0
        ld c,a
        ld ix,mechagfx
        add ix,bc

        ld l,(ix+0)
        ld h,(ix+1)
        ld de,$4600
        ld bc,$0200
        call copy3times

        ld l,(ix+2)
        ld h,(ix+3)
        ld de,$6600
        ld bc,$0200
        call copy3times

        pop de

        ld l,(ix+4)
        ld h,(ix+5)

        ld b,7  ;debugging
a81        
        ld c,$99
        di
        out (c),e
        push af
        pop af
        out (c),d
        ei

        ld c,8  ;debugging
a80
        ld a,(hl)
        out ($98),a
        nop
        inc hl
        dec c
        jr nz,a80
        ld iy,$0020
        add iy,de
        push iy
        pop de
        dec b
        jr nz,a81

        ret


a71
;        halt
a152
        ld a,(hl)
        inc hl
        cp $20
        jr nz,a72
        ld a,$40
a72
        cp $3F
        jr nc,a73
        add a,$2B
a73
        add a,$40
        out (c),a       ; unit name
        dec b
        jr nz,a152
        ret

erasemecha
        ld b,7  ;debugging
a515        
        ld c,$99
        di
        out (c),e
        push af
        pop af
        out (c),d
        ei

        ld c,8  ;debugging
a514
        ld a,$80
        out ($98),a
        nop
        dec c
        jr nz,a514

        ld iy,$0020
        add iy,de
        push iy
        pop de
        dec b
        jr nz,a515

        ret

bintodec
        ld de,0
bintodecb
        ld bc,10000
        call a75

        ld d,0
bintodec4
        ld bc,1000
        call a75
bintodec3
        ld bc,100
        ld d,b
        call a75

        ld bc,10
        ld d,b
        call a75

        ld bc,1
        ld d,b
        ld e,c
        call a75

        ret
        
a75
        ld a,h
        cp b
        jr c,a76
        jr nz,a74
        ld a,l
        cp c
        jr c,a76
a74
        scf
        ccf
        sbc hl,bc
        inc d
        jr a75
a76
        xor a
        cp e
        jr nz,a79
        cp d
        jr nz,a78
        ld a,$80
        jr a77
a78
        ld e,d
a79
        ld a,$9B
        add a,d
a77
        out ($98),a
        nop
        ret

bintodecs
        ld h,0
        ld de,0
        bit 7,l
        jr nz,a138
        ld bc,$B598
        out (c),b
        jr a139
a138
        ld bc,$B698
        out (c),b
        ld a,h
        sub l
        ld l,a
a139

        ld bc,10
        ld d,b
        call a75

        ld bc,1
        ld d,b
        call a75

        ret

setvrama
        halt
setvrama2
        di
        ld c,$99
        out (c),e
        push af
        pop af
        out (c),d
        ei
        ret

setvrama3
        halt
setvrama4
        push hl
        ld hl,($E028)
        add hl,de
        di
        ld c,$99
        out (c),l
        push af
        pop af
        out (c),h
        ei
        pop hl
        ret

clearobits
        xor a
        ld hl,$E6E0
        ld (hl),a               ; clear some RAM
        ld de,$E6E1             ;
        ld bc,$003F
        ldir
        ret

clearspr
        xor a
        ld hl,$E280
a68
        dec hl
        ld (hl),a
        cp l
        jr nz,a68
        ret

placewindow
        ld bc,($E012)           ; crosshair position
        ld a,7
        cp c
        jr nc,a67
        ld de,$5985
        ld bc,$2862
        ld ($E016),bc
        ret
a67
        ld de,$5993
        ld bc,$9862
        ld ($E016),bc
        ret

updateunitmap
        ld bc,($E00B)           ; c=h b=v
        ld hl,$F000
        ld d,b
        xor a
        ; first write zeros to entire map
a58
        ld e,c
a57
        ld (hl),a
        inc hl
        dec e
        jr nz,a57
        dec d
        jr nz,a58

        ; then process unit list
        ld ix,$E280
        ld l,1
a56
        ld a,(ix+8)
        cp 0
        jr z,a59
        ld h,(ix+15)
        ld iy,$F000
        xor a
        cp h
        jr z,a63
        ld e,c
a60
        add iy,de               ; baka multiplication
        dec h                   ;
        jr nz,a60
a63
        ld e,(ix+13)
        add iy,de
a106
        ld a,(iy+0)
        cp 0                    ;
        jr z,a105               ; automatically move units if they are in the
        inc iy                  ; same spot as another unit
        inc iy
        inc e
        inc e
        ld a,(iy+0)
        cp 0
        jr z,a105
        inc iy
        inc iy
        inc e
        inc e
        ld a,(iy+0)
        cp 0
        jr z,a105
        inc (ix+15)
        ld a,e
        sub 5
        ld e,a
        push de
        ld a,c
        sub 5
        ld e,a
        add iy,de
        pop de
        jr a106
a105
        ld (iy+0),l
        ld (ix+13),e
a59
        ld e,$10
        add ix,de
        inc l
        ld a,l
        cp $41
        jr nz,a56
        
        ret

searchunitmap
        ld de,($E012)           ; e=h d=v
searchunitmap2
        ld bc,($E00B)           ; c=h b=v
        ld hl,$F000
        ld b,0
        xor a
        cp d
        jr z,a64
a61
        add hl,bc               ; baka multiplication again
        dec d                   ;
        jr nz,a61
a64
        add hl,de
        ld a,(hl)
        ret

searchterrain
        ld de,($E012)           ; e=h d=v       crosshair position
searchterrain2
        ld hl,walkaddrs
        ld a,($E00A)
        sla a
        ld c,a
        ld b,0
        add hl,bc
        ld c,(hl)
        inc hl
        ld b,(hl)
        push bc
        pop hl
        ld bc,($E00B)           ; c=h b=v       current map dimensions
        srl c
        srl c
        xor a
        ld b,a
        cp d
        jr z,a163
a162
        add hl,bc               ; baka multiplication again
        dec d                   ;
        jr nz,a162
a163
        ld a,e
        and 3
        ld b,a
        srl e
        srl e
        add hl,de
        ld c,(hl)
        xor a
        cp b
        jr z,a166
a167
        srl c
        srl c
        dec b
        jr nz,a167
a166
        ld a,3
        and c
        ret

waitbutton
        halt
        ld a,($E006)
        and 48
        cp 48
        jr z,waitbutton
        ret

placeunits
        ld ix,$E280
        ld c,$40
a40
        ld a,(ix+8)
        cp 0
        jr z,a41
        ld a,(ix+7)
        srl a
        and 12
        add a,$60
        push af

        ld a,(ix+13)
        ld de,($E00F)
        sub e

        ; probably should test whether its off the screen here
        jp m,a489
        cp 16
        jp nc,a489

        sla a
        ld e,a
        ld a,(ix+15)
        sub d

        ; and here
        jp m,a489
        cp 12
        jp nc,a489

        ld hl,$5800
        srl a
        rr l
        srl a
        rr l
        add a,h
        ld h,a
        ld a,l
;        and $C0
        or e
        di
        out ($99),a
        push af
        pop af
        ld l,a
        ld a,h
        out ($99),a
        ei

        pop af
        push af
        pop af
        out ($98),a
        push af
        pop af
        inc a
        ld b,a
        out ($98),a

        ld de,$0020
        add hl,de
        ld a,l
        di
        out ($99),a
        push af
        pop af
        ld a,h
        out ($99),a
        ei
        nop

        ld a,b
        inc a
        out ($98),a
        push af
        pop af
        inc a
        out ($98),a

a41
        ld de,$0010
        add ix,de
        dec c
        jr nz,a40

        ret
a489
        pop af
        jr a41

loadmap
        ld ($E00A),a
        sla a
        sla a
        sla a
        sla a
        ld c,a
        ld b,0

        ld a,($E011)
        cp 0
        jr nz,a504
        ld ix,mapaddrs
        jr a506
a504
        cp 1
        jr nz,a505
        ld ix,mapaddrs2
        jr a506
a505
        ld ix,mapaddrs3
a506

        add ix,bc

        ld l,(ix+0)
        ld h,(ix+1)
        ld de,$4000
        ld bc,$0300
        call copy3times
        ld l,(ix+2)
        ld h,(ix+3)
        ld de,$6000
        ld bc,$0300
        call copy3times
        ld a,(ix+4)
        ld ($E00D),a
        ld a,(ix+5)
        ld ($E00E),a
        ld a,(ix+6)
        ld ($E00B),a
        ld a,(ix+7)
        ld ($E00C),a
        ret

loadmapunits

        ld b,0
a94
        ld l,(ix+8)
        ld h,(ix+9)
a104
        ld c,(hl)
        xor a
        cp c
        jr z,a95

        inc hl
        call addunits

        inc hl
        inc hl
        inc hl
        inc hl
        inc hl
        inc hl
        jr a104
a95
        inc ix
        inc ix
        inc b
        ld a,4
        cp b
        jr nz,a94

        ret

addunits
        push ix

        ld ix,$E280
a96
        push hl
        pop iy
        ld a,(ix+8)     ; pilot number
        cp 0
        jp nz,a97

        ld a,(iy+0)
        ld (ix+13),a    ; h position
        ld a,(iy+1)
        ld (ix+15),a    ; v position
        ld a,(iy+3)
        ld (ix+8),a     ; pilot number
        ld a,(iy+4)
        ld (ix+11),a    ; structure upgrades
        ld d,a
        sla a
        sla a
        sla a
        sla a
        or d
        ld (ix+12),a    ; weapon and speed upgrades
        ld a,(iy+5)
        ld (ix+9),a     ; pilot level

        ld a,(iy+2)
        dec a
        ld (ix+6),a     ; unit type
        sla a
        ld e,a
        ld d,0
        ld iy,mechpointers
        add iy,de
        ld d,(iy+1)
        ld e,(iy+0)
        push de
        pop iy

        push hl

; HP + upgrades
        ld l,(iy+12)
        ld h,(iy+13)
        ld a,(ix+11)
        cp 0
        jr z,a98
        ld de,200
a99
        add hl,de
        dec a
        jr nz,a99
a98
        ld (ix+0),l
        ld (ix+1),h

; EN + upgrades
        ld l,(iy+14)
        ld h,(iy+15)
        ld a,(ix+11)
        cp 0
        jr z,a100
        ld de,10
a101
        add hl,de
        dec a
        jr nz,a101
a100
        ld (ix+2),l
        ld (ix+3),h

; armor + upgrades
        ld l,(iy+16)
        ld h,(iy+17)
        ld a,(ix+11)
        cp 0
        jr z,a102
        ld de,100
a103
        add hl,de
        dec a
        jr nz,a103
a102
        ld (ix+4),l
        ld (ix+5),h


;poop
;        jp poop

        ld a,b
        ld hl,$E011
        cp (hl)                 ; is the unit added to player's team?
        jr nz,a464
;poop
;        jp poop
        ld a,($E03E)
        inc a
        ld ($E03E),a
        add a,$BF
        ld l,a
        ld h,$E6
        ld a,(ix+8)
        ld (hl),a
        ld a,($E03E)
        sla a
        add a,$7F
        ld l,a
        ld a,(ix+9)
        ld (hl),a
        ld a,b
a464
        pop hl
        sla a
        sla a
        sla a
        or (iy+11)               ; unit attributes
        ld (ix+7),a             

        dec c
        jr nz,a97
        pop ix
        ret
a97
        ld de,$0010
        add ix,de
        ; um... what should I do if the units list is... FULL!?
        jp a96        

scrollmap
        ld hl,($E00D)
        ld de,$5800
        ld bc,($E00B)        
        ld a,c
        cp 16
        jr nz,a39
        ld a,b
        cp 12
        jr nz,a39
        ld bc,$0300
        call copyonce
        xor a
        ld ($E00F),a            ; maybe not needed...
        ld ($E010),a            ;
        ret
a39
        ld b,c
        call setvrama2
        ld de,($E00F)           ; load scroll offsets
        ld a,d
        ld d,0
        sla e
        add hl,de               ; add h*2 to source address
        cp 0
        jr z,a499
        ld e,b
        sla e
        sla e
a496
        add hl,de               ; add width*2*v*2 to source address
        dec a                   ;
        jr nz,a496
a499
        ;ld a,b
        ld a,($E00B)
        sla a
        sub 32
;        srl a
        ld e,a
        ld c,24
a498
        ld b,32
a497
        ld a,(hl)
        inc hl
        out ($98),a
        djnz a497
        add hl,de
        dec c
        jr nz,a498

        ret

fillwstats
                ; b has the weapon number

        push bc
        push de

        xor a
        ld ($E048),a

        ld iy,($E020)
        ld a,b
        ld ($E045),a
        sla a
        sla a
        sla a
        ld c,a
        sla a
        add a,c
        ld c,a
        ld b,0
        add iy,bc

; AMMO
        ld de,$5A06
        call setvrama
        ld a,(iy+19)
        cp 0
        jr z,a134
        ld a,($E045)
        ld hl,($E046)
        add a,l
        jr nc,a227
        inc h
a227
        ld l,a
        ld a,(hl)
        cp 0
        jr nz,a228              ; any ammo left?
        ld a,128
        ld ($E048),a
        xor a
a228
        ld l,a
        ld de,0
        ld h,d
        call bintodec3
        jr a135                
a134
        ld bc,$8098
        out (c),b
        push af
        pop af
        out (c),b
        push af
        pop af
        out (c),b
        nop
a135
        ld a,$A5
        out ($98),a
        ld l,(iy+19)
        ld de,0
        ld h,d
        call bintodec3

; EN
        ld de,$5A16
        call setvrama2
        ld a,(iy+18)
        cp 0
        jr z,a136
        ld l,a
        ld de,0
        ld h,d
        call bintodec3
        jr a137
a136
        ld bc,$8098
        out (c),b
        push af
        pop af
        out (c),b
        push af
        pop af
        out (c),b
        nop
a137
        ld a,$B3
        out ($98),a
        ld ix,($E018)
        ld l,(ix+2)
        ld h,(ix+3)
        xor a
        cp h
        jr nz,a229
        ld a,(iy+18)
        cp l
        jr c,a229              ; is there enough EN?
        jr z,a229
        ld a,128
        ld ($E048),a
a229
        ld de,0
        call bintodec3

        bit 2,(iy+21)
        jr nz,a234
        ld a,($E049)
        bit 2,a
        jr z,a234
        ld a,128
        ld ($E048),a
a234

; critical hit rate

        ld de,$5A36
        call setvrama
        ld l,(iy+17)
        ld de,0
        ld h,d
        call bintodecs

; range

        ld de,$5A56
        call setvrama2
        ld l,(iy+20)
        ld de,0
        ld h,d
        call bintodec3

        ld a,($E064)
        cp 1
        jr nz,a420
        ld a,($E060)
        cp (iy+20)
        jr z,a420
        jr c,a420
        ld a,128
        ld ($E048),a
a420

        pop de
        pop bc
        ret

selectathing
        ld a,7
        ld ($E203),a
;        ld a,0
        xor a
        ld ($E022),a
selectathing2
        ld b,0
        ld ($E202),a

        ld a,100
        ld ($E065),a
        xor a
        ld ($E048),a

a24
        ld a,($E022)
        cp 0
        jr z,a133
        cp 1
        jr z,a259
        ld a,($E006)
        and 12
        cp 12
        jr z,a133
        ld b,64
        ret
a259
        ld a,($E065)
        cp b
        jr z,a133
        ld a,b
        ld ($E065),a
        call fillwstats
a133

        ld a,b
        sla a
        sla a
        sla a
        add a,e
        ld ($E200),a
        ld a,d
        ld ($E201),a

        ld a,($E006)
        bit 1,a
        jr nz,a25
        inc b
        ld a,b
        cp c
        jr nz,a25
        ld b,0
a25
        ld a,($E006)
        bit 0,a
        jr nz,a26
        dec b
        ld a,b
        cp 255
        jr nz,a26
        ld b,c
        dec b
a26
        ld a,($E006)
        bit 4,a
        jr nz,a27
        ld a,($E048)
        bit 7,a
        jr nz,a27
a114
        call clearspr
        ld a,1
        ld ($E004),a
        halt
        ret
a27
        ld a,($E006)
        bit 5,a
        jr nz,a113
        ld b,255
        jr a114
a113
        ld a,1
        ld ($E004),a
        halt
        jp a24

textwindow
        ld c,(hl)
        inc hl
        ld b,(hl)
        inc hl

textwindow2
        di
        ld a,e
        out ($99),a
        nop
        ld a,d
        out ($99),a
        ei

        ld a,c                  ;
        ld ($E007),a            ; UGH!

        ld a,$AB
        out ($98),a
        nop
        inc a
a52
        out ($98),a             ;
        nop
        dec c                   ; top border
        jr nz,a52               ;
        inc a
        out ($98),a
        ld a,e
        add a,$20
        jr nc,a53
        inc d
a53
        ld e,a

a51
        ld c,$99
        di
        out (c),e
        push af
        pop af
        out (c),d
        ei

        ld a,($E007)            ; UGH!
        ld c,a                  ;

        ld a,$AE
        out ($98),a
a19
        ld a,(hl)
        cp $20
        jr nz,a32
        ld a,$60
a32
        add a,$20
a33
        out ($98),a
        inc hl
        dec c
        jr nz,a19
        ld a,$AF
        out ($98),a

a30
        ld a,e
        add a,$20
        jr nc,a29
        inc d
a29
        ld e,a
        dec b
        jr nz,a51

        ld c,$99
        di
        out (c),e
        push af
        pop af
        out (c),d
        ei

        ld a,($E007)            ; UGH!
        ld c,a                  ;
        ld a,$B0
        out ($98),a
        inc a
        nop
a54
        out ($98),a             ;
        nop
        dec c                   ; bottom border
        jr nz,a54               ;
        inc a
        out ($98),a

        ret

copyonce
        di
        ld a,e
        out ($99),a
        push af
        pop af
        ld a,d
        out ($99),a
        ei
a14
        nop
        ld a,(hl)
        inc hl
        out ($98),a
        dec c
        jr nz,a14
        dec b
        jr nz,a14
        ret

copyflipped
        di
        ld a,e
        out ($99),a
        push af
        pop af
        ld a,d
        out ($99),a
        ei
a192
        ld d,(hl)
        inc hl
        ld e,8
a193
        sla d
        rr a
        dec e
        jr nz,a193
        out ($98),a
        dec c
        jr nz,a192
        dec b
        jr nz,a192
        ret

cleargamedata
;        ld a,0
        xor a
        ld hl,$E280
        ld (hl),a               ; clear some RAM
        ld de,$E281             ;
        ld bc,$04BF
        ldir
        ret

clearvram
        di
;        ld a,0
        xor a
        out ($99),a
        nop
        ld a,$40
        out ($99),a
        ei
        ld bc,$4000
        ld a,c
a16
        out ($98),a
        push af
        pop af
        push af
        pop af
        dec c
        jr nz,a16
        dec b
        jr nz,a16
        ret

copy3times
        ld ($E007),bc
        ld a,e
        ld ($E009),a
        ld e,3
a13
        di
        out ($99),a
        ld a,d
        push af
        pop af
        out ($99),a
        ei
        ld bc,($E007)
        push hl
a12
        ld a,(hl)
        inc hl
        out ($98),a
        nop
        dec c
        jr nz,a12
        dec b
        jr nz,a12
        pop hl
        ld a,8
        add a,d
        ld d,a
        ld a,($E009)
        dec e
        jr nz,a13
        ret

setbw
        di
        ld bc,$0099
        out (c),b
        push af
        pop af
        ld b,$60
        out (c),b
        ei
        ld bc,$1800
a22
        ld a,$F0
        out ($98),a
        push af
        pop af
        dec c
        jr nz,a22
        dec b
        jr nz,a22
        ret

kanaled
        ld bc,$0FA0
        out (c),b
        in a,($A2)              ; toggle kana LED
        xor 128
        out (c),b
        out ($A1),a
        ret

soundoff
        ld bc,$08A0
;        ld a,0
        xor a
        out (c),b
        nop
        out ($A1),a
        inc b
        out (c),b
        nop
        out ($A1),a
        inc b
        out (c),b
        nop
        out ($A1),a

;        ld a,0
        xor a
        ld hl,$E080
        ld (hl),a               ; clear music player register area
        ld de,$E081             ;
        ld bc,$0040
        ldir
        
        ret

displaystarf
        ld hl,starfblk
        ld de,$4000
        ld bc,$0400
        call copy3times
        ld hl,starf3blk
        ld de,$45F0
        ld bc,$0310
        call copy3times
        ld hl,starfclr
        ld de,$6000
        ld bc,$0400
        call copy3times
        ld hl,starf3clr
        ld de,$65F0
        ld bc,$0310
        call copy3times
        ld hl,starfmap
        ld de,$5800
        ld bc,$0300
        call copyonce
        ret

displayweird
        ld hl,weirdblk
        ld de,$4000
        ld bc,$0400
        call copy3times
        ld hl,weirdclr
        ld de,$6000
        ld bc,$0400
        call copy3times
        ld hl,weirdmap
        ld de,$5800
        ld bc,$0300
        call copyonce
        ret

vdpregs
        db 2,226,6,255,3,56,7,0
;
; VRAM setup
; $0000         character set
; $1800         name table
; $1C00         sprite attributes table
; $2000         color map
; $3800         sprite character set
;

hitwin
        db 4,1
        db "pow",$89

misswin
        db 7,1
        db "whoosh",$89


introwin1
        db 26,6
        db "       mecha taisen       "
        db "    on planet oldskool    "
        db "                          "
        db "oldskool",$86,$86,$86," the first     "
        db "planet in a distant solar "
        db "system",$86,"                   "

introwin2
        db 26,7
        db "three competing races live"
        db "here and have recently    "
        db "experienced a period of   "
        db "rapid technological       "
        db "advancement",$88," adding some  "
        db "interesting war machines  "
        db "to their militaries",$86,"      "

introwin3
        db 26,8
        db "suddenly",$88," a previously    "
        db "unknown enemy approaches  "
        db "from space and attacks",$88,"   "
        db "sparking a four",$96,"sided war",$86
        db "                          "
        db "the winner will surely be "
        db "decided by a combination  "
        db "of cleverness and power",$86,$86,$86

endturnwin
        db 9,3
        db "end turn",$87
        db "   yes   "
        db "   no    "

battlewin
        db 13,2
        db "hp           "
        db "en           "

attackinfwin
        db 26,13
        db "pilot              lv     "
        db "unit                      "
        db "hp                        "
        db "en                        "
        db "weapon                    "
        db "chance to hit             "
        db "           vs",$86,"            "
        db "pilot              lv     "
        db "unit                      "
        db "hp                        "
        db "en                        "
        db "weapon                    "
        db "chance to hit             "

targettedwin
        db 20,4
        db "player is targetted",$89
        db " counterattack      "
        db " defend             "
        db " evade              "

upgradewin
        db 18,2
        db " upgrade structure"
        db " upgrade mobility "

statswin
        db 26,12
        db "unit                      "
        db "hp                        "
        db "en                        "
        db "agility                   "
        db "armor                     "
        db "                          "
        db "pilot                     "
        db "lv         sp             "
        db "aim        evasion        "
        db "skill      reflex         "
        db "fighting ability          "
        db "close      distant        "

weaponswin
        db 28,10
        db "weapon name        power acc"
emptywin
        db "                            "
        db "                            "
        db "                            "
        db "                            "
        db "                            "
        db "                            "
        db "ammo          en       ",$93,"   ",$94
        db "critical hit rate           "
        db "range                       "

teammenu
        db 18,4
        db " choose your team "
        db " team mega super x"
        db " team ataranakya  "
        db " team kami doa    "

mapmenu1
        db 7,6
        db "terrain"
        db " grass "
        db "defense"
        db " normal"
        db "evasion"
        db " normal"
mapmenu2
        db 7,6
        db "terrain"
        db " woods "
        db "defense"
        db " bonus "
        db "evasion"
        db " bonus "
mapmenu3
        db 7,6
        db "terrain"
        db " water "
        db "defense"
        db " bonus "
        db "evasion"
        db " normal"
mapmenu4
        db 7,6
        db "terrain"
        db " sand  "
        db "defense"
        db " normal"
        db "evasion"
        db " normal"
mapmenu5
        db 7,6
        db "terrain"
        db " dunes "
        db "defense"
        db " bonus "
        db "evasion"
        db " bonus "

unitmenu
        db 7,4
        db " move  "
        db " attack"
;        db " magic "
        db " stats "
        db " cancel"

movedmenu
        db 7,3
        db " attack"
        db " done  "
        db " cancel"

earnedwin
        db 14,2
        db "earned     exp"
        db " and    ",$7A," cash"

interwin1
        db 12,1
        db "intermission"

interwin2
        db 24,1
        db "last area    cash       "

interwin3
        db 16,5
        db " see stats      "
        db " assign pilot   "
        db " upgrade units  "
        db " upgrade weapons"
        db " goto next area "

interwin4
        db 12,1
        db "which pilot",$87

interwin5
        db 14,1
        db "to which unit",$87

interwin6
        db 6,1
        db "status"

interwin7
        db 13,1
        db "upgrade units"

interwin8
        db 15,1
        db "upgrade weapons"

notenoughwin
        db 15,1
        db "not enough cash"

upgradeconfirm
        db 13,3
        db "cost is      "
        db " ok          "
        db " cancel      "

areaclearwin
        db 8,2
        db "  area  "
        db "cleared",$89

gameoverwin
        db 8,2
        db "  game  "
        db "  over  "

spritepats

;  \
;  /
        db 0,0,0,0,0,0,0,0
        db 0,0,0,0,0,0,0,0
        db 128
        db 64
        db 32
        db 16
        db 8
        db 4
        db 2
        db 1
        db 1
        db 2
        db 4
        db 8
        db 16
        db 32
        db 64
        db 128

; square pointer
        db $F0,$80,$80,$80,0,0,0,0
        db 0,0,0,0,$80,$80,$80,$F0
        db $0F,1,1,1,0,0,0,0
        db 0,0,0,0,1,1,1,$0F
; movement pointer
        db 3,7,15,0,$20,$60,$E0,$E0
        db $E0,$E0,$60,$20,0,15,7,3
        db $C0,$E0,$F0,0,4,6,7,7
        db 7,7,6,4,0,$F0,$E0,$C0
; X pointer
        db $80,$40,$20,$10,8,4,2,1
        db 1,2,4,8,$10,$20,$40,$80
        db 1,2,4,8,$10,$20,$40,$80
        db $80,$40,$20,$10,8,4,2,1
; red dot pointer
        db 0,$3C,$7E,$7E,$7E,$7E,$3C,0
        db 0,0,0,0,0,0,0,0
        db 0,0,0,0,0,0,0,0
        db 0,0,0,0,0,0,0,0
; explosions
        incbin "explode1.spr"        
        incbin "explode2.spr"        
        incbin "explode3.spr"        


mechpointers
        dw themechdata          ; = tms9918a
        dw mpsg
        dw mz80a
        dw m6502c
        dw m6510
        dw mgtia
        dw mantic
        dw mpokey
        dw msid
        dw mvic2

        dw m4164
        dw m41256
        dw m44256
        dw mv9938
        dw mv9958
        dw mv9990
        dw mdenise
        dw mted
        dw mvdc
        dw m68000

        dw mr800
        dw m80286
        dw m80386
        dw m80486
        dw mmaria
        dw mqpokey

noweapon
        db " NONE           ",128,0,0,0,0,0
        db 255,255

themechdata
        db "TMS9918A",70,5,0,3
        dw 3200,100,800,2000
        db "32MM AUTO GUN   ",-5,0,0,10,4,0
        dw 1000
        db "BEAM SWORD      ",15,10,0,0,1,5
        dw 1100
        db "SPRITES         ",20,0,0,32,6,1
        dw 1200

; name, agility, movement, flags, number of weapons
;    HP,EN,ARM,cost
;                      acc,critical,en,ammo,range,flags
;       damage

mpsg
        db "PSG     ",70,5,0,3
        dw 3000,80,750,1600
        db "PARALLEL VULCANS",30,-20,0,8,1,4
        dw 800
        db "LASER           ",0,10,0,6,5,2
        dw 1100
        db "BEAM SWORD      ",15,10,0,0,1,5
        dw 1100

; unit flags bit0=flying bit1=shield bit2=nosword bit3-4=team (not used here)
;               bit5=moved already

; weapon flags bit0=blockable bit1=beam bit2="P" bit3=MAP

mz80a
        db "Z80A    ",65,5,3,2
        dw 3500,120,900,2200
        db "HOMING LASER    ",15,-10,15,0,5,2
        dw 1200
        db "LARGE AXE       ",10,10,0,0,1,5
        dw 1300

m6502c
        db "6502C   ",80,6,0,2
        dw 3100,110,850,2100
        db "GATLING CANNON  ",5,10,0,8,3,4
        dw 1100
        db "BEAM DAGGERS    ",10,20,0,0,1,5
        dw 1100

m6510
        db "6510    ",75,6,0,3
        dw 3100,110,850,2100
        db "PORT VULCAN     ",30,-20,0,8,1,4
        dw 700
        db "GATLING CANNON  ",5,10,0,8,3,4
        dw 1100
        db "BEAM DAGGERS    ",10,20,0,0,1,5
        dw 1100

mgtia
        db "GTIA    ",70,5,4,3
        dw 3000,80,750,1500
        db "MISSLE LAUNCHER ",5,0,0,4,4,1
        dw 1000
        db "LUMINANCE BEAM  ",0,10,10,0,6,2
        dw 1200
        db "CHROMA BEAM     ",-10,0,15,0,5,2
        dw 1300

mantic
        db "ANTIC   ",70,5,0,3
        dw 3100,90,800,1600
        db "40MM AUTO GUN   ",-5,0,0,10,4,0
        dw 1100
        db "BEAM SWORD      ",15,10,0,0,1,5
        dw 1100
        db "INTERRUPTOR     ",10,20,10,0,1,4
        dw 1150

mpokey
        db "POKEY   ",70,5,4,3
        dw 3000,80,750,1500
        db "SERIAL VULCAN   ",20,-20,0,8,2,4
        dw 900
        db "LASER           ",0,0,0,8,5,2
        dw 1050
        db "DUAL LASER      ",5,10,0,4,6,2
        dw 1150

msid
        db "SID     ",70,5,0,2
        dw 3100,90,800,1700
        db "BEAM SWORD      ",15,10,0,0,1,5
        dw 1100
        db "LASER           ",0,10,0,6,5,2
        dw 1150

mvic2
        db "VIC2    ",70,5,0,3
        dw 3200,100,800,1900
        db "40MM AUTO GUN   ",-5,0,0,10,4,0
        dw 1100
        db "BEAM SWORD      ",15,10,0,0,1,5
        dw 1100
        db "SPRITES         ",10,0,0,8,5,1
        dw 1300

m4164
        db "4164    ",60,4,2,2
        dw 2800,80,700,1000
        db "STEEL SWORD     ",10,10,0,0,1,5
        dw 1000
        db "32MM AUTO GUN   ",-5,0,0,10,4,0
        dw 1000

m41256
        db "41256   ",75,5,2,2
        dw 3300,110,850,1900
        db "BEAM SWORD      ",15,10,0,0,1,5
        dw 1200
        db "64MM AUTO GUN   ",-5,0,0,10,5,0
        dw 1300

m44256
        db "44256   ",85,6,2,2
        dw 3700,130,950,2400
        db "BEAM SWORD      ",15,10,0,0,1,5
        dw 1400
        db "80MM AUTO GUN   ",-5,0,0,10,5,0
        dw 1400

mv9938
        db "V9938   ",80,6,0,3
        dw 3600,130,1000,3000
        db "64MM AUTO GUN   ",-5,0,0,10,5,0
        dw 1300
        db "SPRITES         ",20,0,0,32,6,1
        dw 1350
        db "RGB BEAM SWORD  ",15,10,0,0,1,5
        dw 1400

mv9958
        db "V9958   ",80,6,0,3
        dw 3700,130,1000,3100
        db "64MM AUTO GUN   ",-5,0,0,10,5,0
        dw 1300
        db "SPRITES         ",20,0,0,32,6,1
        dw 1350
        db "YJK BEAM SWORD  ",15,10,0,0,1,5
        dw 1500

mv9990
        db "V9990   ",90,6,0,3
        dw 4500,170,1300,4000
        db "80MM AUTO GUN   ",-5,0,0,10,5,0
        dw 1400
        db "HYPER BEAM SWORD",20,10,10,0,1,5
        dw 1900
        db "SPRITES         ",25,0,0,32,7,1
        dw 2000

mdenise
        db "DENISE  ",80,5,0,3
        dw 3700,110,950,2700
        db "BEAM SWORD      ",15,10,0,0,1,5
        dw 1400
        db "EHB LASER       ",0,10,10,0,6,2
        dw 1500
        db "HAM LASER       ",-10,0,15,0,5,2
        dw 1600

mted
        db "TED     ",75,5,0,3
        dw 3300,110,900,2000
        db "40MM AUTO GUN   ",-5,0,0,10,4,0
        dw 1100
        db "BEAM SWORD      ",15,10,0,0,1,5
        dw 1200
        db "LUMINANCE BEAM  ",0,10,10,0,6,2
        dw 1200

mvdc
        db "VDC     ",75,5,0,2
        dw 3400,110,900,2200
        db "BEAM SWORD      ",15,10,0,0,1,5
        dw 1100
        db "80MM AUTO GUN   ",-5,0,0,10,5,0
        dw 1400

m68000
        db "68000   ",85,6,3,3
        dw 4200,150,1100,3800
        db "QUICK MISSLE POD",0,0,0,8,4,5
        dw 1100
        db "LARGE BEAM SWORD",20,10,0,0,1,5
        dw 1700
        db "MEGA BEAM CANNON",-10,0,30,0,6,4
        dw 1800 

mr800
        db "R800    ",100,7,3,2
        dw 3600,130,1050,3300
        db "HOMING LASER    ",15,-10,20,0,6,2
        dw 1500
        db "BEAM BATTLE AXE ",10,10,0,0,1,5
        dw 1500

m80286
        db "80286   ",95,6,3,4
        dw 4000,140,1050,4000
        db "QUICK MISSLE POD",0,0,0,8,4,5
        dw 1100
        db "SEGMENTED ARM   ",5,10,0,8,2,4
        dw 1400
        db "PULSE LASER     ",0,10,15,0,4,2
        dw 1500
        db "BEAM BATTLE AXE ",10,10,0,0,1,5
        dw 1600

m80386
        db "80386   ",100,6,3,4
        dw 4400,150,1100,5000
        db "QUICK MISSLE POD",0,0,0,8,4,5
        dw 1100
        db "UNSEGMENTED ARM ",5,10,0,8,2,4
        dw 1600
        db "BEAM BATTLE AXE ",10,10,0,0,1,5
        dw 1700
        db "MEGA BEAM CANNON",-10,0,30,0,6,4
        dw 1800 

m80486
        db "80486   ",110,7,3,4
        dw 4600,180,1200,5600
        db "QUICK MISSLE POD",0,0,0,8,4,5
        dw 1100
        db "UNSEGMENTED ARM ",5,10,0,8,2,4
        dw 1600
        db "BEAM BATTLE AXE ",10,10,0,0,1,5
        dw 1700
        db "MEGA BEAM CANNON",-10,0,35,0,6,4
        dw 2000 

mmaria
        db "MARIA   ",70,5,0,4
        dw 3100,90,800,1700
        db "BEAM SWORD      ",15,10,0,0,1,5
        dw 1150
        db "INTERRUPTOR     ",10,20,10,0,1,4
        dw 1150
        db "LUMINANCE BEAM  ",0,10,10,0,6,2
        dw 1200
        db "CHROMA BEAM     ",-10,0,15,0,5,2
        dw 1300

mqpokey
        db "QUADPOKY",75,5,4,4
        dw 3600,120,750,3000
        db "SERIAL VULCAN   ",20,-20,0,16,2,4
        dw 900
        db "LASER           ",0,0,0,16,5,2
        dw 1050
        db "DUAL LASER      ",5,10,0,8,6,2
        dw 1150
        db "MULTILASER      ",5,20,0,4,6,2
        dw 1400


pilotdata
        db " NONE   "
        db 0,0,0,0,0,0
        db 0,0

        ; close, ranged, evasion, aim, reflex, skill, seishin x 2
        ; #1 --\

        db "FRED    "
        db 123,135,148,141,161,165
        db 0,9

        db "MIEKO   "
        db 125,149,151,150,163,166
        db 2,4

        db "LYNDSEY "
        db 151,135,149,147,163,170
        db 3,7

        db "MAXWELL "
        db 150,150,139,155,155,175
        db 8,1

        db $3C,$3C,$3C,$3C,"    "
        db 118,127,132,134,153,154
        db 0,0

        db "RYUICHI "
        db 139,127,140,142,159,166
        db 5,0

        db "CARLOS  "
        db 134,144,141,145,158,159
        db 0,6

        db "HANS    "
        db 157,131,137,139,155,170
        db 3,8

        db "AMI     "
        db 122,160,153,143,162,160
        db 9,2

        ; close, ranged, evasion, aim, reflex, skill, seishin x 2
        ; #10 --\

        db "VICTOR  "
        db 147,139,148,140,157,171
        db 9,2

        db "HIROFUMI"
        db 113,150,155,152,151,161
        db 9,2

        db "JULIA   "
        db 150,152,142,160,171,151
        db 9,2

        db "KATE    "
        db 159,130,147,154,151,166
        db 9,2

        db "LEO     "
        db 135,127,150,150,156,157
        db 9,2

        db "JITKA   "
        db 153,153,149,161,167,155
        db 9,2

        db "JOE     "
        db 136,152,148,153,161,167
        db 4,5

        db "ROLAND  "
        db 147,160,138,147,153,177
        db 9,2

        ; close, ranged, evasion, aim, reflex, skill, seishin x 2
        ; #18 --\

        db "JUSTIN  "
        db 146,113,148,134,155,171
        db 9,2

        db "DMITRY  "
        db 126,114,140,142,157,176
        db 9,2

        db "BRIDGET "
        db 133,133,152,141,165,155
        db 9,2

        db "EMILY   "
        db 121,141,133,145,172,156
        db 9,2

        db "TOMAS   "
        db 151,131,140,159,165,167
        db 9,2

        db "AKANE   "
        db 133,117,148,152,172,172
        db 9,2

        db "DANA    "
        db 113,139,158,144,166,163
        db 9,2

        db "RORY    "
        db 138,135,142,143,156,152
        db 9,2


seishin
        db "REPAIR1",20         ; 2000HP
        db "REPAIR2",40         ; 5000HP
        db "REPAIR3",30         ; 2000HP for ally
        db "ANGER  ",40         ; 2x damage
        db "EVASION",15         ; hirameki

        db "SIGHT  ",20         ; next attack is 100% hit
        db "STEALTH",50         ; invisible to enemies for 1 turn
        db "SPEED  ",10         ; movement
        db "DEFENSE",30         ; double armor for a turn
        db "STUN   ",35         ; target enemy can't move for 1 turn

mechagfx
        dw domub,domuc2,domum
        dw zssab,zssac,zssam
        dw draisenb,draisenc,draisenm

        dw hambrabib,hambrabic,hambrabim
        dw hambrabib,hambrabic2,hambrabim
        dw zssab,zssac2,zssam

        dw marasaib,marasaic2,marasaim
        dw zssab,zssac,zssam

        dw zssab,zssac,zssam
        dw draisenb,draisenc2,draisenm

        dw marasaib,marasaic,marasaim
        dw marasaib,marasaic,marasaim
        dw marasaib,marasaic,marasaim

        dw domub,domuc,domum
        dw domub,domuc,domum
        dw domub,domuc,domum


        dw marasaib,marasaic,marasaim
        dw draisenb,draisenc2,draisenm
        dw draisenb,draisenc2,draisenm
        dw marasaib,marasaic,marasaim

        dw draisenb,draisenc,draisenm
        dw draisenb,draisenc2,draisenm
        dw draisenb,draisenc2,draisenm
        dw draisenb,draisenc2,draisenm
        dw marasaib,marasaic2,marasaim

domub
        incbin "domu.b1"
        incbin "domu.b2"
        incbin "domu.b3"
        incbin "domu.b4"
domuc
        incbin "domu.c1"
        incbin "domu.c2"
        incbin "domu.c3"
        incbin "domu.c4"
domuc2
        incbin "domu.c5"
        incbin "domu.c6"
        incbin "domu.c7"
        incbin "domu.c8"
domum
        incbin "domu.mm"

zssab
        incbin "zssa.b1"
        incbin "zssa.b2"
        incbin "zssa.b3"
        incbin "zssa.b4"
zssac
        incbin "zssa.c1"
        incbin "zssa.c2"
        incbin "zssa.c3"
        incbin "zssa.c4"
zssac2
        incbin "zssa.c5"
        incbin "zssa.c6"
        incbin "zssa.c7"
        incbin "zssa.c8"
zssam
        incbin "zssa.mm"

draisenb
        incbin "draisen.b1"
        incbin "draisen.b2"
        incbin "draisen.b3"
        incbin "draisen.b4"
draisenc
        incbin "draisen.c1"
        incbin "draisen.c2"
        incbin "draisen.c3"
        incbin "draisen.c4"
draisenc2
        incbin "draisen.c5"
        incbin "draisen.c6"
        incbin "draisen.c7"
        incbin "draisen.c8"
draisenm
        incbin "draisen.mm"

marasaib
        incbin "marasai.b1"
        incbin "marasai.b2"
        incbin "marasai.b3"
        incbin "marasai.b4"
marasaic
        incbin "marasai.c1"
        incbin "marasai.c2"
        incbin "marasai.c3"
        incbin "marasai.c4"
marasaic2
        incbin "marasai.c5"
        incbin "marasai.c6"
        incbin "marasai.c7"
        incbin "marasai.c8"
marasaim
        incbin "marasai.mm"

hambrabib
        incbin "hambrabi.b1"
        incbin "hambrabi.b2"
        incbin "hambrabi.b3"
        incbin "hambrabi.b4"
hambrabic
        incbin "hambrabi.c1"
        incbin "hambrabi.c2"
        incbin "hambrabi.c3"
        incbin "hambrabi.c4"
hambrabic2
        incbin "hambrabi.c5"
        incbin "hambrabi.c6"
        incbin "hambrabi.c7"
        incbin "hambrabi.c8"
hambrabim
        incbin "hambrabi.mm"

nounits
        db 0

area1aunits0
        db 1            ; number of units
        db 2,2          ; h,v position
        db 1,1         ; unit type, pilot
        db 0,1          ; unit upgrades, pilot level
        db 1            ; number of units
        db 2,2          ; h,v position
        db 3,3         ; unit type, pilot
        db 0,1          ; unit upgrades, pilot level
        db 1            ; number of units
        db 2,2          ; h,v position
        db 2,2         ; unit type, pilot
        db 0,1          ; unit upgrades, pilot level
        db 1            ; number of units
        db 2,2          ; h,v position
        db 11,6         ; unit type, pilot
        db 0,1          ; unit upgrades, pilot level
        db 0

area1bunits1   
        db 1            ; number of units
        db 2,2          ; h,v position
        db 4,10        ; unit type, pilot
        db 0,1          ; unit upgrades, pilot level
        db 1            ; number of units
        db 2,2          ; h,v position
        db 6,11        ; unit type, pilot
        db 0,1          ; unit upgrades, pilot level
        db 1            ; number of units
        db 2,2          ; h,v position
        db 7,12        ; unit type, pilot
        db 0,1          ; unit upgrades, pilot level
        db 1            ; number of units
        db 2,2          ; h,v position
        db 8,13        ; unit type, pilot
        db 0,1          ; unit upgrades, pilot level
        db 0

area1cunits2   
        db 1            ; number of units
        db 2,2          ; h,v position
        db 5,18        ; unit type, pilot
        db 0,1          ; unit upgrades, pilot level
        db 1            ; number of units
        db 2,2          ; h,v position
        db 9,19        ; unit type, pilot
        db 0,1          ; unit upgrades, pilot level
        db 1            ; number of units
        db 2,2          ; h,v position
        db 10,20        ; unit type, pilot
        db 0,1          ; unit upgrades, pilot level
        db 1            ; number of units
        db 2,2          ; h,v position
        db 11,21        ; unit type, pilot
        db 0,1          ; unit upgrades, pilot level
        db 0

area1aunits3
area1bunits3
area1cunits3
        db 5            ; number of units
        db 5,7          ; h,v position
        db 11,5         ; unit type, pilot
        db 0,1          ; unit upgrades, pilot level
        db 1            ; number of units
        db 5,7          ; h,v position
        db 12,5         ; unit type, pilot
        db 0,2          ; unit upgrades, pilot level
        db 0

area2aunits0
        db 1           ; number of units
        db 1,9          ; h,v position
        db 14,7         ; unit type, pilot
        db 0,2         ; unit upgrades, pilot level
        db 0

area2bunits1
        db 1           ; number of units
        db 1,9          ; h,v position
        db 11,14        ; unit type, pilot
        db 0,3         ; unit upgrades, pilot level
        db 0

area2cunits2
        db 1           ; number of units
        db 1,9          ; h,v position
        db 18,22         ; unit type, pilot
        db 0,3         ; unit upgrades, pilot level
        db 0

area2aunits2
area2bunits2
        db 1            ; number of units
        db 5,9          ; h,v position
        db 5,18        ; unit type, pilot
        db 0,4          ; unit upgrades, pilot level
        db 1            ; number of units
        db 5,9          ; h,v position
        db 9,19        ; unit type, pilot
        db 0,4          ; unit upgrades, pilot level
        db 1            ; number of units
        db 5,9          ; h,v position
        db 10,20        ; unit type, pilot
        db 0,4          ; unit upgrades, pilot level
        db 5            ; number of units
        db 5,9          ; h,v position
        db 11,5         ; unit type, pilot
        db 0,3          ; unit upgrades, pilot level
        db 0

area2cunits0
        db 1            ; number of units
        db 5,9          ; h,v position
        db 1,1         ; unit type, pilot
        db 0,4          ; unit upgrades, pilot level
        db 1            ; number of units
        db 5,9          ; h,v position
        db 3,3         ; unit type, pilot
        db 0,4          ; unit upgrades, pilot level
        db 1            ; number of units
        db 5,9          ; h,v position
        db 2,2         ; unit type, pilot
        db 0,4          ; unit upgrades, pilot level
        db 5            ; number of units
        db 5,9          ; h,v position
        db 11,5         ; unit type, pilot
        db 0,3          ; unit upgrades, pilot level
        db 0

area3aunits0
        db 1           ; number of units
        db 1,9          ; h,v position
        db 12,8         ; unit type, pilot
        db 0,3         ; unit upgrades, pilot level
        db 0

area3bunits1
        db 1           ; number of units
        db 1,9          ; h,v position
        db 26,15         ; unit type, pilot
        db 0,4         ; unit upgrades, pilot level
        db 0

area3cunits2
        db 1           ; number of units
        db 1,9          ; h,v position
        db 12,23         ; unit type, pilot
        db 0,4         ; unit upgrades, pilot level
        db 0

area3aunits1
area3cunits1
        db 1            ; number of units
        db 5,9          ; h,v position
        db 4,10         ; unit type, pilot
        db 1,6          ; unit upgrades, pilot level
        db 1            ; number of units
        db 5,9          ; h,v position
        db 6,11         ; unit type, pilot
        db 1,6          ; unit upgrades, pilot level
        db 1            ; number of units
        db 5,9          ; h,v position
        db 7,12         ; unit type, pilot
        db 1,6          ; unit upgrades, pilot level
        db 1            ; number of units
        db 5,9          ; h,v position
        db 8,13         ; unit type, pilot
        db 1,6          ; unit upgrades, pilot level
        db 3            ; number of units
        db 5,9          ; h,v position
        db 11,5         ; unit type, pilot
        db 1,4          ; unit upgrades, pilot level
        db 2            ; number of units
        db 5,9          ; h,v position
        db 11,5         ; unit type, pilot
        db 0,4          ; unit upgrades, pilot level
        db 0

area3bunits0
        db 1            ; number of units
        db 5,9          ; h,v position
        db 1,1         ; unit type, pilot
        db 1,6          ; unit upgrades, pilot level
        db 1            ; number of units
        db 5,9          ; h,v position
        db 3,3         ; unit type, pilot
        db 1,6          ; unit upgrades, pilot level
        db 1            ; number of units
        db 5,9          ; h,v position
        db 2,2         ; unit type, pilot
        db 1,6          ; unit upgrades, pilot level
        db 4            ; number of units
        db 5,9          ; h,v position
        db 11,5         ; unit type, pilot
        db 1,4          ; unit upgrades, pilot level
        db 2            ; number of units
        db 5,9          ; h,v position
        db 11,5         ; unit type, pilot
        db 0,4          ; unit upgrades, pilot level
        db 0

area4aunits0
        db 1           ; number of units
        db 1,9          ; h,v position
        db 15,9         ; unit type, pilot
        db 0,5         ; unit upgrades, pilot level
        db 0

area4bunits1
        db 1           ; number of units
        db 1,9          ; h,v position
        db 12,16         ; unit type, pilot
        db 0,5         ; unit upgrades, pilot level
        db 0

area4cunits2
        db 1           ; number of units
        db 1,9          ; h,v position
        db 19,24         ; unit type, pilot
        db 0,5         ; unit upgrades, pilot level
        db 0

area4aunits3
area4bunits3
area4cunits3
        db 1            ; number of units
        db 4,1          ; h,v position
        db 22,5         ; unit type, pilot
        db 1,7          ; unit upgrades, pilot level
        db 8           ; number of units
        db 4,1          ; h,v position
        db 12,5         ; unit type, pilot
        db 0,6         ; unit upgrades, pilot level
        db 0

area5aunits0
        db 1           ; number of units
        db 1,1          ; h,v position
        db 21,4         ; unit type, pilot
        db 0,7         ; unit upgrades, pilot level
        db 0

area5bunits1 
        db 1           ; number of units
        db 16,5          ; h,v position
        db 25,17         ; unit type, pilot
        db 1,7         ; unit upgrades, pilot level
        db 0

area5cunits2 
        db 1           ; number of units
        db 3,14          ; h,v position
        db 12,25         ; unit type, pilot
        db 1,7         ; unit upgrades, pilot level
        db 0

area5aunits3
area5bunits3
area5cunits3
        db 1            ; number of units
        db 7,7          ; h,v position
        db 24,5         ; unit type, pilot
        db 1,9           ; unit upgrades, pilot level
        db 1            ; number of units
        db 7,7          ; h,v position
        db 23,5         ; unit type, pilot
        db 1,9          ; unit upgrades, pilot level
        db 8           ; number of units
        db 7,7          ; h,v position
        db 13,5         ; unit type, pilot
        db 1,7         ; unit upgrades, pilot level
        db 0


area5bunits0
area5cunits0
        db 1            ; number of units
        db 1,1          ; h,v position
        db 1,1         ; unit type, pilot
        db 1,8          ; unit upgrades, pilot level
        db 1            ; number of units
        db 1,1          ; h,v position
        db 3,3         ; unit type, pilot
        db 1,8          ; unit upgrades, pilot level
        db 1            ; number of units
        db 1,1          ; h,v position
        db 2,2         ; unit type, pilot
        db 1,8          ; unit upgrades, pilot level
        db 1            ; number of units
        db 1,1          ; h,v position
        db 11,6         ; unit type, pilot
        db 1,8          ; unit upgrades, pilot level
        db 1            ; number of units
        db 1,1          ; h,v position
        db 14,7         ; unit type, pilot
        db 1,8          ; unit upgrades, pilot level
        db 0

area5aunits1
area5cunits1
        db 1            ; number of units
        db 15,4          ; h,v position
        db 4,10         ; unit type, pilot
        db 1,8          ; unit upgrades, pilot level
        db 1            ; number of units
        db 15,4          ; h,v position
        db 6,11         ; unit type, pilot
        db 1,8          ; unit upgrades, pilot level
        db 1            ; number of units
        db 15,4          ; h,v position
        db 7,12         ; unit type, pilot
        db 1,8          ; unit upgrades, pilot level
        db 1            ; number of units
        db 15,4          ; h,v position
        db 8,13         ; unit type, pilot
        db 1,8          ; unit upgrades, pilot level
        db 1            ; number of units
        db 15,4          ; h,v position
        db 11,14         ; unit type, pilot
        db 1,8          ; unit upgrades, pilot level
        db 0

area5aunits2
area5bunits2
        db 1            ; number of units
        db 3,14          ; h,v position
        db 5,18        ; unit type, pilot
        db 1,8          ; unit upgrades, pilot level
        db 1            ; number of units
        db 3,14          ; h,v position
        db 9,19        ; unit type, pilot
        db 1,8          ; unit upgrades, pilot level
        db 1            ; number of units
        db 3,14          ; h,v position
        db 10,20        ; unit type, pilot
        db 1,8          ; unit upgrades, pilot level
        db 1            ; number of units
        db 3,14          ; h,v position
        db 11,21         ; unit type, pilot
        db 1,8          ; unit upgrades, pilot level
        db 1            ; number of units
        db 3,14          ; h,v position
        db 18,22         ; unit type, pilot
        db 1,8          ; unit upgrades, pilot level
        db 0

starfblk
        incbin "starf2.blk"
starfclr
        incbin "starf2.clr"
starfmap
        incbin "starf2.map"
starf3blk
        incbin "starf3.blk"
starf3clr
        incbin "starf3.clr"

weirdblk
        incbin "weird.blk"
weirdclr
        incbin "weird.clr"
weirdmap
        incbin "weird.map"

intermus
        incbin "inter.dt"
        db 255
        dw intermus+5

        org $BF00
; init routine for .COM mode
        di
        ld de,0
        ld hl,$0100
        ld bc,$BF01
        ldir

;        ld a,0
        xor a
        ld ($4000),a            ; be rid of ROM header since
                                ; we are not in ROM!
        ld hl,$E000
        ld (hl),a               ; clear some RAM
        ld de,$E001             ;
        ld bc,$03FF
        ldir

        ld hl,$E1FF
        ld sp,hl

        jp a7

        org $BFFF
        db 0

